/*
 * Decompiled with CFR 0.152.
 */
package com.ashokvarma.gander.internal.data;

import android.arch.lifecycle.LiveData;
import android.arch.paging.DataSource;
import android.arch.persistence.room.Dao;
import android.arch.persistence.room.Delete;
import android.arch.persistence.room.Insert;
import android.arch.persistence.room.Query;
import android.arch.persistence.room.Update;
import android.support.annotation.IntRange;
import com.ashokvarma.gander.internal.data.HttpTransaction;
import java.util.Date;

@Dao
public abstract class TransactionDao {
    public static final int SEARCH_DEFAULT = 1;
    public static final int SEARCH_INCLUDE_REQUEST = 2;
    public static final int SEARCH_INCLUDE_RESPONSE = 3;
    public static final int SEARCH_INCLUDE_REQUEST_RESPONSE = 4;

    @Insert(onConflict=1)
    public abstract long insertTransaction(HttpTransaction var1);

    @Update(onConflict=1)
    public abstract int updateTransaction(HttpTransaction var1);

    @Delete
    public abstract int deleteTransactions(HttpTransaction ... var1);

    @Query(value="DELETE FROM HttpTransaction WHERE request_date < :beforeDate")
    public abstract int deleteTransactionsBefore(Date var1);

    @Query(value="DELETE FROM HttpTransaction")
    public abstract int clearAll();

    @Query(value="SELECT * FROM HttpTransaction ORDER BY id DESC")
    public abstract DataSource.Factory<Integer, HttpTransaction> getAllTransactions();

    @Query(value="SELECT * FROM HttpTransaction WHERE id = :id")
    public abstract LiveData<HttpTransaction> getTransactionsWithId(long var1);

    public DataSource.Factory<Integer, HttpTransaction> getAllTransactionsWith(String key, @IntRange(from=1L, to=4L) int searchType) {
        String endWildCard = key + "%";
        String doubleSideWildCard = "%" + key + "%";
        switch (searchType) {
            case 1: {
                return this.getAllTransactions(endWildCard, doubleSideWildCard);
            }
            case 2: {
                return this.getAllTransactionsIncludeRequest(endWildCard, doubleSideWildCard);
            }
            case 3: {
                return this.getAllTransactionsIncludeResponse(endWildCard, doubleSideWildCard);
            }
            case 4: {
                return this.getAllTransactionsIncludeRequestResponse(endWildCard, doubleSideWildCard);
            }
        }
        return this.getAllTransactions(endWildCard, doubleSideWildCard);
    }

    @Query(value="SELECT id, method, url, path, host, scheme, request_date, error, response_code, took_ms, request_content_length, response_content_length, request_body_is_plain_text, response_body_is_plain_text FROM HttpTransaction WHERE protocol LIKE :endWildCard OR method LIKE :endWildCard OR url LIKE :doubleWildCard OR request_body LIKE :doubleWildCard OR response_body LIKE :doubleWildCard OR response_message LIKE :doubleWildCard OR response_code LIKE :endWildCard ORDER BY id DESC")
    abstract DataSource.Factory<Integer, HttpTransaction> getAllTransactionsIncludeRequestResponse(String var1, String var2);

    @Query(value="SELECT id, method, url, path, host, scheme, request_date, error, response_code, took_ms, request_content_length, response_content_length, request_body_is_plain_text, response_body_is_plain_text FROM HttpTransaction WHERE protocol LIKE :endWildCard OR method LIKE :endWildCard OR url LIKE :doubleWildCard OR response_body LIKE :doubleWildCard OR response_message LIKE :doubleWildCard OR response_code LIKE :endWildCard ORDER BY id DESC")
    abstract DataSource.Factory<Integer, HttpTransaction> getAllTransactionsIncludeResponse(String var1, String var2);

    @Query(value="SELECT id, method, url, path, host, scheme, request_date, error, response_code, took_ms, request_content_length, response_content_length, request_body_is_plain_text, response_body_is_plain_text FROM HttpTransaction WHERE protocol LIKE :endWildCard OR method LIKE :endWildCard OR url LIKE :doubleWildCard OR request_body LIKE :doubleWildCard OR response_code LIKE :endWildCard ORDER BY id DESC")
    abstract DataSource.Factory<Integer, HttpTransaction> getAllTransactionsIncludeRequest(String var1, String var2);

    @Query(value="SELECT id, method, url, path, host, scheme, request_date, error, response_code, took_ms, request_content_length, response_content_length, request_body_is_plain_text, response_body_is_plain_text FROM HttpTransaction WHERE protocol LIKE :endWildCard OR method LIKE :endWildCard OR url LIKE :doubleWildCard OR response_code LIKE :endWildCard ORDER BY id DESC")
    abstract DataSource.Factory<Integer, HttpTransaction> getAllTransactions(String var1, String var2);
}

