/*
 * Decompiled with CFR 0.152.
 */
package com.ashokvarma.gander.internal.data;

import android.arch.persistence.room.ColumnInfo;
import android.arch.persistence.room.Entity;
import android.arch.persistence.room.Ignore;
import android.arch.persistence.room.PrimaryKey;
import android.net.Uri;
import android.support.annotation.Nullable;
import com.ashokvarma.gander.internal.data.HttpHeader;
import com.ashokvarma.gander.internal.support.FormatUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;

@Entity(tableName="HttpTransaction")
public class HttpTransaction {
    @PrimaryKey(autoGenerate=true)
    private long id;
    @ColumnInfo(name="request_date")
    private Date requestDate;
    @ColumnInfo(name="response_date")
    private Date responseDate;
    @ColumnInfo(name="took_ms")
    private Long tookMs;
    @ColumnInfo(name="protocol")
    private String protocol;
    @ColumnInfo(name="method")
    private String method;
    @ColumnInfo(name="url")
    private String url;
    @ColumnInfo(name="host")
    private String host;
    @ColumnInfo(name="path")
    private String path;
    @ColumnInfo(name="scheme")
    private String scheme;
    @ColumnInfo(name="request_content_length")
    private Long requestContentLength;
    @ColumnInfo(name="request_content_type")
    private String requestContentType;
    @ColumnInfo(name="request_headers")
    private List<HttpHeader> requestHeaders;
    @ColumnInfo(name="request_body", typeAffinity=2)
    private String requestBody;
    @ColumnInfo(name="request_body_is_plain_text")
    private boolean requestBodyIsPlainText = true;
    @ColumnInfo(name="response_code")
    private Integer responseCode;
    @ColumnInfo(name="response_message")
    private String responseMessage;
    @ColumnInfo(name="error")
    private String error;
    @ColumnInfo(name="response_content_length")
    private Long responseContentLength;
    @ColumnInfo(name="response_content_type")
    private String responseContentType;
    @ColumnInfo(name="response_headers")
    private List<HttpHeader> responseHeaders;
    @ColumnInfo(name="response_body", typeAffinity=2)
    private String responseBody;
    @ColumnInfo(name="response_body_is_plain_text")
    private boolean responseBodyIsPlainText = true;
    private static final SimpleDateFormat TIME_ONLY_FMT = new SimpleDateFormat("HH:mm:ss", Locale.US);
    @Ignore
    public String searchKey;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Date getRequestDate() {
        return this.requestDate;
    }

    public void setRequestDate(Date requestDate) {
        this.requestDate = requestDate;
    }

    public Date getResponseDate() {
        return this.responseDate;
    }

    public void setResponseDate(Date responseDate) {
        this.responseDate = responseDate;
    }

    public Long getTookMs() {
        return this.tookMs;
    }

    public void setTookMs(Long tookMs) {
        this.tookMs = tookMs;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public Long getRequestContentLength() {
        return this.requestContentLength;
    }

    public void setRequestContentLength(Long requestContentLength) {
        this.requestContentLength = requestContentLength;
    }

    public String getRequestContentType() {
        return this.requestContentType;
    }

    public void setRequestContentType(String requestContentType) {
        this.requestContentType = requestContentType;
    }

    public List<HttpHeader> getRequestHeaders() {
        return this.requestHeaders;
    }

    public void setRequestHeaders(List<HttpHeader> requestHeaders) {
        this.requestHeaders = requestHeaders;
    }

    public String getRequestBody() {
        return this.requestBody;
    }

    public void setRequestBody(String requestBody) {
        this.requestBody = requestBody;
    }

    public boolean requestBodyIsPlainText() {
        return this.requestBodyIsPlainText;
    }

    public void setRequestBodyIsPlainText(boolean requestBodyIsPlainText) {
        this.requestBodyIsPlainText = requestBodyIsPlainText;
    }

    public Integer getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(Integer responseCode) {
        this.responseCode = responseCode;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public void setResponseMessage(String responseMessage) {
        this.responseMessage = responseMessage;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public Long getResponseContentLength() {
        return this.responseContentLength;
    }

    public void setResponseContentLength(Long responseContentLength) {
        this.responseContentLength = responseContentLength;
    }

    public String getResponseContentType() {
        return this.responseContentType;
    }

    public void setResponseContentType(String responseContentType) {
        this.responseContentType = responseContentType;
    }

    public List<HttpHeader> getResponseHeaders() {
        return this.responseHeaders;
    }

    public void setResponseHeaders(List<HttpHeader> responseHeaders) {
        this.responseHeaders = responseHeaders;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public void setResponseBody(String responseBody) {
        this.responseBody = responseBody;
    }

    public boolean responseBodyIsPlainText() {
        return this.responseBodyIsPlainText;
    }

    public void setResponseBodyIsPlainText(boolean responseBodyIsPlainText) {
        this.responseBodyIsPlainText = responseBodyIsPlainText;
    }

    public void setUrlHostPathSchemeFromUrl(String url) {
        this.setUrl(url);
        Uri uri = Uri.parse((String)url);
        this.setHost(uri.getHost());
        this.setPath(uri.getPath() + (uri.getQuery() != null ? "?" + uri.getQuery() : ""));
        this.setScheme(uri.getScheme());
    }

    public CharSequence getFormattedRequestBody() {
        return this.formatBody(this.requestBody, this.requestContentType);
    }

    public CharSequence getFormattedResponseBody() {
        return this.formatBody(this.responseBody, this.responseContentType);
    }

    public Status getStatus() {
        if (this.error != null) {
            return Status.Failed;
        }
        if (this.responseCode == null) {
            return Status.Requested;
        }
        return Status.Complete;
    }

    public String getNotificationText() {
        switch (this.getStatus()) {
            case Failed: {
                return " ! ! !  " + this.path;
            }
            case Requested: {
                return " . . .  " + this.path;
            }
        }
        return String.valueOf(this.responseCode) + " " + this.path;
    }

    public boolean isSsl() {
        return this.scheme.toLowerCase().equals("https");
    }

    public String getRequestStartTimeString() {
        return this.requestDate != null ? TIME_ONLY_FMT.format(this.requestDate) : null;
    }

    public String getRequestDateString() {
        return this.requestDate != null ? this.requestDate.toString() : null;
    }

    public String getResponseDateString() {
        return this.responseDate != null ? this.responseDate.toString() : null;
    }

    public String getDurationString() {
        return this.tookMs != null ? this.tookMs + " ms" : null;
    }

    public String getRequestSizeString() {
        return this.formatBytes(this.requestContentLength != null ? this.requestContentLength : 0L);
    }

    public String getResponseSizeString() {
        return this.responseContentLength != null ? this.formatBytes(this.responseContentLength) : null;
    }

    public String getTotalSizeString() {
        long reqBytes = this.requestContentLength != null ? this.requestContentLength : 0L;
        long resBytes = this.responseContentLength != null ? this.responseContentLength : 0L;
        return this.formatBytes(reqBytes + resBytes);
    }

    public String getResponseSummaryText() {
        switch (this.getStatus()) {
            case Failed: {
                return this.error;
            }
            case Requested: {
                return null;
            }
        }
        return String.valueOf(this.responseCode) + " " + this.responseMessage;
    }

    private CharSequence formatBody(String body, @Nullable String contentType) {
        if (contentType != null) {
            if (contentType.toLowerCase().contains("json")) {
                return FormatUtils.formatJson(body);
            }
            if (contentType.toLowerCase().contains("xml")) {
                return FormatUtils.formatXml(body);
            }
            if (contentType.toLowerCase().contains("form-urlencoded")) {
                return FormatUtils.formatFormEncoded(body);
            }
        }
        return body;
    }

    private String formatBytes(long bytes) {
        return FormatUtils.formatByteCount(bytes, true);
    }

    public CharSequence getResponseHeadersString(boolean withMarkup) {
        return FormatUtils.formatHeaders(this.getResponseHeaders(), withMarkup);
    }

    public CharSequence getRequestHeadersString(boolean withMarkup) {
        return FormatUtils.formatHeaders(this.getRequestHeaders(), withMarkup);
    }

    public static enum Status {
        Requested,
        Complete,
        Failed;

    }
}

