/*
 * Decompiled with CFR 0.152.
 */
package com.asarkar.gradle.buildtimetracker;

import com.asarkar.gradle.buildtimetracker.BarPosition;
import com.asarkar.gradle.buildtimetracker.Output;
import com.asarkar.gradle.buildtimetracker.Printer;
import com.asarkar.gradle.buildtimetracker.PrinterInput;
import com.asarkar.gradle.buildtimetracker.Sort;
import com.asarkar.gradle.buildtimetracker.TimingRecorder;
import java.io.Closeable;
import java.io.File;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Comparator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationCompletionListener;
import org.gradle.tooling.events.task.TaskFinishEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/asarkar/gradle/buildtimetracker/TimingRecorder;", "Lorg/gradle/api/services/BuildService;", "Lcom/asarkar/gradle/buildtimetracker/TimingRecorder$Params;", "Lorg/gradle/tooling/events/OperationCompletionListener;", "Ljava/lang/AutoCloseable;", "()V", "buildStart", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "taskDurations", "", "Lkotlin/Pair;", "", "", "close", "", "onFinish", "event", "Lorg/gradle/tooling/events/FinishEvent;", "Params", "build-time-tracker"})
@SourceDebugExtension(value={"SMAP\nTimingRecorder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimingRecorder.kt\ncom/asarkar/gradle/buildtimetracker/TimingRecorder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,68:1\n1053#2:69\n1053#2:70\n*S KotlinDebug\n*F\n+ 1 TimingRecorder.kt\ncom/asarkar/gradle/buildtimetracker/TimingRecorder\n*L\n53#1:69\n54#1:70\n*E\n"})
public abstract class TimingRecorder
implements BuildService<Params>,
OperationCompletionListener,
AutoCloseable {
    @NotNull
    private final Collection<Pair<String, Long>> taskDurations = new ConcurrentLinkedQueue();
    @NotNull
    private final AtomicReference<Instant> buildStart = new AtomicReference<Instant>(Instant.now().plus(30L, ChronoUnit.DAYS));

    public void onFinish(@NotNull FinishEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event instanceof TaskFinishEvent) {
            Instant eventStart = Instant.ofEpochMilli(((TaskFinishEvent)event).getResult().getStartTime());
            this.buildStart.accumulateAndGet(eventStart, onFinish.1.INSTANCE);
            long duration = Duration.ofMillis(((TaskFinishEvent)event).getResult().getEndTime() - ((TaskFinishEvent)event).getResult().getStartTime()).getSeconds();
            if (duration >= ((Duration)((Params)this.getParameters()).getMinTaskDuration().get()).getSeconds()) {
                this.taskDurations.add((Pair<String, Long>)TuplesKt.to((Object)((TaskFinishEvent)event).getDescriptor().getTaskPath(), (Object)duration));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.taskDurations.isEmpty()) {
            return;
        }
        long buildDuration = Duration.between(this.buildStart.get(), Instant.now()).getSeconds();
        Object object = ((Params)this.getParameters()).getOutput().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.output.get()");
        Output output = (Output)((Object)object);
        File file = ((Directory)((Params)this.getParameters()).getReportsDir().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"parameters.reportsDir.get().asFile");
        Closeable closeable = Printer.Companion.newInstance(output, file);
        Throwable throwable = null;
        try {
            Printer printer = (Printer)closeable;
            boolean bl = false;
            Object object2 = ((Params)this.getParameters()).getSortBy().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"parameters.sortBy.get()");
            Sort sortBy = (Sort)((Object)object2);
            Collection durations = switch (WhenMappings.$EnumSwitchMapping$0[sortBy.ordinal()]) {
                case 1 -> this.taskDurations;
                case 2 -> {
                    Iterable $this$sortedBy$iv = this.taskDurations;
                    boolean $i$f$sortedBy = false;
                    yield CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            Pair it = (Pair)a;
                            boolean bl = false;
                            Comparable comparable = Long.valueOf(-((Number)it.getSecond()).longValue());
                            it = (Pair)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(-((Number)it.getSecond()).longValue()));
                        }
                    });
                }
                case 3 -> {
                    Iterable $this$sortedBy$iv = this.taskDurations;
                    boolean $i$f$sortedBy = false;
                    yield CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            Pair it = (Pair)a;
                            boolean bl = false;
                            Comparable comparable = (Long)it.getSecond();
                            it = (Pair)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Long)it.getSecond()));
                        }
                    });
                }
                default -> throw new NoWhenBranchMatchedException();
            };
            Object object3 = ((Params)this.getParameters()).getMaxWidth().get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"parameters.maxWidth.get()");
            int n = ((Number)object3).intValue();
            Object object4 = ((Params)this.getParameters()).getShowBars().get();
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"parameters.showBars.get()");
            boolean bl2 = (Boolean)object4;
            Object object5 = ((Params)this.getParameters()).getBarPosition().get();
            Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"parameters.barPosition.get()");
            PrinterInput input = new PrinterInput(buildDuration, durations, n, bl2, (BarPosition)((Object)object5));
            printer.print(input);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0006R\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0006R\u0012\u0010\u0010\u001a\u00020\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0006R\u0018\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0006\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001a\u00c0\u0006\u0001"}, d2={"Lcom/asarkar/gradle/buildtimetracker/TimingRecorder$Params;", "Lorg/gradle/api/services/BuildServiceParameters;", "barPosition", "Lorg/gradle/api/provider/Property;", "Lcom/asarkar/gradle/buildtimetracker/BarPosition;", "getBarPosition", "()Lorg/gradle/api/provider/Property;", "maxWidth", "", "getMaxWidth", "minTaskDuration", "Ljava/time/Duration;", "getMinTaskDuration", "output", "Lcom/asarkar/gradle/buildtimetracker/Output;", "getOutput", "reportsDir", "Lorg/gradle/api/file/DirectoryProperty;", "getReportsDir", "()Lorg/gradle/api/file/DirectoryProperty;", "showBars", "", "getShowBars", "sortBy", "Lcom/asarkar/gradle/buildtimetracker/Sort;", "getSortBy", "build-time-tracker"})
    public static interface Params
    extends BuildServiceParameters {
        @NotNull
        public Property<BarPosition> getBarPosition();

        @NotNull
        public Property<Sort> getSortBy();

        @NotNull
        public Property<Output> getOutput();

        @NotNull
        public Property<Integer> getMaxWidth();

        @NotNull
        public Property<Duration> getMinTaskDuration();

        @NotNull
        public Property<Boolean> getShowBars();

        @NotNull
        public DirectoryProperty getReportsDir();
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Sort.values().length];
            try {
                nArray[Sort.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Sort.DESC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Sort.ASC.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

