/*
 * Decompiled with CFR 0.152.
 */
package com.asarkar.gradle.buildtimetracker;

import com.asarkar.gradle.buildtimetracker.BarPosition;
import com.asarkar.gradle.buildtimetracker.Output;
import com.asarkar.gradle.buildtimetracker.Printer;
import com.asarkar.gradle.buildtimetracker.PrinterInput;
import com.asarkar.gradle.buildtimetracker.Sort;
import com.asarkar.gradle.buildtimetracker.TimingRecorder;
import java.io.Closeable;
import java.io.File;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Comparator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationCompletionListener;
import org.gradle.tooling.events.task.TaskFinishEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/asarkar/gradle/buildtimetracker/TimingRecorder;", "Lorg/gradle/api/services/BuildService;", "Lcom/asarkar/gradle/buildtimetracker/TimingRecorder$Params;", "Lorg/gradle/tooling/events/OperationCompletionListener;", "Ljava/lang/AutoCloseable;", "()V", "buildStart", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "taskDurations", "", "Lkotlin/Pair;", "", "", "close", "", "onFinish", "event", "Lorg/gradle/tooling/events/FinishEvent;", "Params", "build-time-tracker"})
public abstract class TimingRecorder
implements BuildService<Params>,
OperationCompletionListener,
AutoCloseable {
    @NotNull
    private final Collection<Pair<String, Long>> taskDurations = new ConcurrentLinkedQueue();
    @NotNull
    private final AtomicReference<Instant> buildStart = new AtomicReference<Instant>(Instant.now().plus(30L, ChronoUnit.DAYS));

    public void onFinish(@NotNull FinishEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event instanceof TaskFinishEvent) {
            Instant eventStart = Instant.ofEpochMilli(((TaskFinishEvent)event).getResult().getStartTime());
            this.buildStart.accumulateAndGet(eventStart, onFinish.1.INSTANCE);
            long duration = Duration.ofMillis(((TaskFinishEvent)event).getResult().getEndTime() - ((TaskFinishEvent)event).getResult().getStartTime()).getSeconds();
            if (duration >= ((Duration)((Params)this.getParameters()).getMinTaskDuration().get()).getSeconds()) {
                this.taskDurations.add((Pair<String, Long>)TuplesKt.to((Object)((TaskFinishEvent)event).getDescriptor().getTaskPath(), (Object)duration));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.taskDurations.isEmpty()) {
            return;
        }
        long buildDuration = Duration.between(this.buildStart.get(), Instant.now()).getSeconds();
        Object object = ((Params)this.getParameters()).getOutput().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.output.get()");
        Output output = (Output)((Object)object);
        object = ((Directory)((Params)this.getParameters()).getReportsDir().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.reportsDir.get().asFile");
        object = Printer.Companion.newInstance(output, (File)object);
        Throwable throwable = null;
        try {
            Collection collection;
            Sort sort;
            Printer printer = (Printer)object;
            boolean bl = false;
            Object object2 = ((Params)this.getParameters()).getSort().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"parameters.sort.get()");
            if (((Boolean)object2).booleanValue()) {
                sort = Sort.DESC;
            } else {
                object2 = ((Params)this.getParameters()).getSortBy().get();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"parameters.sortBy.get()");
                sort = (Sort)((Object)object2);
            }
            Sort sort2 = sort;
            switch (WhenMappings.$EnumSwitchMapping$0[sort2.ordinal()]) {
                case 1: {
                    collection = this.taskDurations;
                    break;
                }
                case 2: {
                    Iterable $this$sortedBy$iv = this.taskDurations;
                    boolean $i$f$sortedBy = false;
                    collection = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            Pair it = (Pair)a;
                            boolean bl = false;
                            Comparable comparable = Long.valueOf(-((Number)it.getSecond()).longValue());
                            it = (Pair)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(-((Number)it.getSecond()).longValue()));
                        }
                    });
                    break;
                }
                case 3: {
                    Iterable $this$sortedBy$iv = this.taskDurations;
                    boolean $i$f$sortedBy = false;
                    collection = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            Pair it = (Pair)a;
                            boolean bl = false;
                            Comparable comparable = (Long)it.getSecond();
                            it = (Pair)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Long)it.getSecond()));
                        }
                    });
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Collection durations = collection;
            Object object3 = ((Params)this.getParameters()).getMaxWidth().get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"parameters.maxWidth.get()");
            int n = ((Number)object3).intValue();
            object3 = ((Params)this.getParameters()).getShowBars().get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"parameters.showBars.get()");
            boolean bl2 = (Boolean)object3;
            object3 = ((Params)this.getParameters()).getBarPosition().get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"parameters.barPosition.get()");
            PrinterInput input = new PrinterInput(buildDuration, durations, n, bl2, (BarPosition)((Object)object3));
            printer.print(input);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0006R\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0006R\u0012\u0010\u0010\u001a\u00020\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0006R\u0018\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0006R\u0018\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0006\u00a8\u0006\u001c"}, d2={"Lcom/asarkar/gradle/buildtimetracker/TimingRecorder$Params;", "Lorg/gradle/api/services/BuildServiceParameters;", "barPosition", "Lorg/gradle/api/provider/Property;", "Lcom/asarkar/gradle/buildtimetracker/BarPosition;", "getBarPosition", "()Lorg/gradle/api/provider/Property;", "maxWidth", "", "getMaxWidth", "minTaskDuration", "Ljava/time/Duration;", "getMinTaskDuration", "output", "Lcom/asarkar/gradle/buildtimetracker/Output;", "getOutput", "reportsDir", "Lorg/gradle/api/file/DirectoryProperty;", "getReportsDir", "()Lorg/gradle/api/file/DirectoryProperty;", "showBars", "", "getShowBars", "sort", "getSort", "sortBy", "Lcom/asarkar/gradle/buildtimetracker/Sort;", "getSortBy", "build-time-tracker"})
    public static interface Params
    extends BuildServiceParameters {
        @NotNull
        public Property<BarPosition> getBarPosition();

        @NotNull
        public Property<Boolean> getSort();

        @NotNull
        public Property<Sort> getSortBy();

        @NotNull
        public Property<Output> getOutput();

        @NotNull
        public Property<Integer> getMaxWidth();

        @NotNull
        public Property<Duration> getMinTaskDuration();

        @NotNull
        public Property<Boolean> getShowBars();

        @NotNull
        public DirectoryProperty getReportsDir();
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Sort.values().length];
            nArray[Sort.NONE.ordinal()] = 1;
            nArray[Sort.DESC.ordinal()] = 2;
            nArray[Sort.ASC.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

