/*
 * Decompiled with CFR 0.152.
 */
package com.asarkar.gradle.buildtimetracker;

import com.asarkar.gradle.buildtimetracker.BarPosition;
import com.asarkar.gradle.buildtimetracker.ConsolePrinter;
import com.asarkar.gradle.buildtimetracker.CsvPrinter;
import com.asarkar.gradle.buildtimetracker.Output;
import com.asarkar.gradle.buildtimetracker.PrinterInput;
import java.io.Closeable;
import java.io.File;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.time.Duration;
import java.util.Arrays;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lcom/asarkar/gradle/buildtimetracker/Printer;", "Ljava/io/Closeable;", "delimiter", "", "getDelimiter", "()Ljava/lang/String;", "out", "Ljava/io/PrintStream;", "getOut", "()Ljava/io/PrintStream;", "print", "", "input", "Lcom/asarkar/gradle/buildtimetracker/PrinterInput;", "Companion", "build-time-tracker"})
public interface Printer
extends Closeable {
    @NotNull
    public static final Companion Companion = com.asarkar.gradle.buildtimetracker.Printer$Companion.$$INSTANCE;
    public static final char BLOCK_CHAR = '\u2588';

    public void print(@NotNull PrinterInput var1);

    @NotNull
    public PrintStream getOut();

    @NotNull
    public String getDelimiter();

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\u0010\t\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0015\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u000eJ\f\u0010\u000f\u001a\u00020\u0010*\u00020\u0011H\u0002J\u0011\u0010\u000f\u001a\u00020\u0010*\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013J\u0014\u0010\u0014\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/asarkar/gradle/buildtimetracker/Printer$Companion;", "", "()V", "BLOCK_CHAR", "", "newInstance", "Lcom/asarkar/gradle/buildtimetracker/Printer;", "output", "Lcom/asarkar/gradle/buildtimetracker/Output;", "reportsDir", "Ljava/io/File;", "newOutputStream", "Ljava/io/PrintStream;", "csvFile", "newOutputStream$build_time_tracker", "format", "", "", "", "format$build_time_tracker", "percentOf", "buildDuration", "build-time-tracker"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        public static final char BLOCK_CHAR = '\u2588';

        private Companion() {
        }

        private final int percentOf(long $this$percentOf, long buildDuration) {
            return (int)Math.rint((double)$this$percentOf / (double)buildDuration * (double)100);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final String format$build_time_tracker(long $this$format) {
            void $this$filterNotTo$iv$iv;
            void $this$filterNot$iv;
            Object object = new Character[]{Character.valueOf('P'), Character.valueOf('D'), Character.valueOf('T')};
            Set separators = SetsKt.setOf((Object[])object);
            object = Duration.ofSeconds($this$format).toString();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ofSeconds(this).toString()");
            boolean $i$f$filterNot = false;
            CharSequence charSequence = (CharSequence)$this$filterNot$iv;
            Appendable destination$iv$iv = new StringBuilder();
            boolean $i$f$filterNotTo = false;
            void var9_8 = $this$filterNotTo$iv$iv;
            for (int i = 0; i < var9_8.length(); ++i) {
                char element$iv$iv;
                char it = element$iv$iv = var9_8.charAt(i);
                boolean bl = false;
                if (separators.contains(Character.valueOf(it))) continue;
                destination$iv$iv.append(element$iv$iv);
            }
            String string = ((StringBuilder)destination$iv$iv).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"filterNotTo(StringBuilder(), predicate).toString()");
            return string;
        }

        private final String format(int $this$format) {
            String string = "%d%%";
            Object[] objectArray = new Object[]{$this$format};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            return string2;
        }

        @NotNull
        public final Printer newInstance(@NotNull Output output, @NotNull File reportsDir) {
            Printer printer;
            Intrinsics.checkNotNullParameter((Object)((Object)output), (String)"output");
            Intrinsics.checkNotNullParameter((Object)reportsDir, (String)"reportsDir");
            switch (WhenMappings.$EnumSwitchMapping$0[output.ordinal()]) {
                case 1: {
                    printer = new ConsolePrinter(null, null, 3, null);
                    break;
                }
                case 2: {
                    File csvFile = FilesKt.resolve((File)reportsDir, (String)"build.csv");
                    printer = new CsvPrinter(this.newOutputStream$build_time_tracker(csvFile), null, 2, null);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return printer;
        }

        @NotNull
        public final PrintStream newOutputStream$build_time_tracker(@NotNull File csvFile) {
            Intrinsics.checkNotNullParameter((Object)csvFile, (String)"csvFile");
            csvFile.getParentFile().mkdirs();
            OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING};
            return new PrintStream(Files.newOutputStream(csvFile.toPath(), openOptionArray), false, StandardCharsets.UTF_8.name());
        }

        static {
            $$INSTANCE = new Companion();
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Output.values().length];
                nArray[Output.CONSOLE.ordinal()] = 1;
                nArray[Output.CSV.ordinal()] = 2;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        /*
         * WARNING - void declaration
         */
        public static void print(@NotNull Printer this_, @NotNull PrinterInput input) {
            void $this$fold$iv;
            void initial$iv;
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Iterable iterable = input.getTaskDurations();
            Triple triple = new Triple((Object)-1, (Object)-1L, (Object)-1);
            boolean $i$f$fold = false;
            Triple accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void elem;
                Pair pair = (Pair)element$iv;
                void acc = accumulator$iv;
                boolean bl = false;
                long maxDuration = Math.max(((Number)acc.getSecond()).longValue(), ((Number)elem.getSecond()).longValue());
                accumulator$iv = new Triple((Object)Math.max(((Number)acc.getFirst()).intValue(), ((String)elem.getFirst()).length()), (Object)maxDuration, (Object)Math.max(((Number)acc.getThird()).intValue(), Companion.format$build_time_tracker(maxDuration).length()));
            }
            void var2_20 = accumulator$iv;
            int maxLabelLen = ((Number)var2_20.component1()).intValue();
            long maxDuration = ((Number)var2_20.component2()).longValue();
            int maxFormattedDurationLen = ((Number)var2_20.component3()).intValue();
            double scalingFraction = (double)Math.min((long)input.getMaxWidth(), maxDuration) / (double)maxDuration;
            int maxNumBlocks = (int)Math.rint((double)maxDuration * scalingFraction);
            int maxFormattedPercentLen = Companion.format(Companion.percentOf(maxDuration, input.getBuildDuration())).length();
            Iterable $this$forEach$iv = input.getTaskDurations();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object[] objectArray;
                String common;
                Pair it = (Pair)element$iv;
                boolean bl = false;
                int numBlocks = (int)Math.rint(((Number)it.getSecond()).doubleValue() * scalingFraction);
                int percent = Companion.percentOf(((Number)it.getSecond()).longValue(), input.getBuildDuration());
                String string = "%" + maxLabelLen + "s%s%" + maxFormattedDurationLen + "s%s%" + maxFormattedPercentLen + "s";
                Object[] objectArray2 = new Object[]{it.getFirst(), this_.getDelimiter(), Companion.format$build_time_tracker(((Number)it.getSecond()).longValue()), this_.getDelimiter(), Companion.format(percent)};
                Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"java.lang.String.format(format, *args)");
                if (!input.getShowBars()) {
                    this_.getOut().println(common);
                    continue;
                }
                if (input.getBarPosition() == BarPosition.TRAILING) {
                    objectArray = new Object[]{common, this_.getDelimiter(), StringsKt.repeat((CharSequence)"\u2588", (int)numBlocks)};
                    this_.getOut().printf("%s%s%s\n", objectArray);
                    continue;
                }
                objectArray = new Object[]{StringsKt.repeat((CharSequence)"\u2588", (int)numBlocks), this_.getDelimiter(), common};
                this_.getOut().printf("%" + maxNumBlocks + "s%s%s\n", objectArray);
            }
        }
    }
}

