/*
 * Decompiled with CFR 0.152.
 */
package com.arxanfintech.common.util;

import com.arxanfintech.common.crypto.core.cryptohash.Keccak256;
import com.arxanfintech.common.crypto.core.cryptohash.Keccak512;
import com.arxanfintech.common.util.ByteUtil;
import com.arxanfintech.common.util.RLP;
import com.arxanfintech.common.util.Utils;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Random;
import org.spongycastle.crypto.digests.RIPEMD160Digest;
import org.spongycastle.util.encoders.Hex;

public class HashUtil {
    public static final byte[] EMPTY_DATA_HASH = HashUtil.sha3(ByteUtil.EMPTY_BYTE_ARRAY);
    public static final byte[] EMPTY_LIST_HASH = HashUtil.sha3(RLP.encodeList(new byte[0][]));
    public static final byte[] EMPTY_TRIE_HASH = HashUtil.sha3(RLP.encodeElement(ByteUtil.EMPTY_BYTE_ARRAY));
    private static final MessageDigest sha256digest;

    public static byte[] sha256(byte[] input) {
        return sha256digest.digest(input);
    }

    public static byte[] sha3(byte[] input) {
        Keccak256 digest = new Keccak256();
        digest.update(input);
        return digest.digest();
    }

    public static byte[] sha3(byte[] input1, byte[] input2) {
        Keccak256 digest = new Keccak256();
        digest.update(input1, 0, input1.length);
        digest.update(input2, 0, input2.length);
        return digest.digest();
    }

    public static byte[] sha3(byte[] input, int start, int length) {
        Keccak256 digest = new Keccak256();
        digest.update(input, start, length);
        return digest.digest();
    }

    public static byte[] sha512(byte[] input) {
        Keccak512 digest = new Keccak512();
        digest.update(input);
        return digest.digest();
    }

    public static byte[] ripemd160(byte[] data) {
        RIPEMD160Digest digest = new RIPEMD160Digest();
        if (data != null) {
            byte[] resBuf = new byte[digest.getDigestSize()];
            digest.update(data, 0, data.length);
            digest.doFinal(resBuf, 0);
            return resBuf;
        }
        throw new NullPointerException("Can't hash a NULL value");
    }

    public static byte[] sha3omit12(byte[] input) {
        byte[] hash = HashUtil.sha3(input);
        return Arrays.copyOfRange(hash, 12, hash.length);
    }

    public static byte[] calcNewAddr(byte[] addr, byte[] nonce) {
        byte[] encSender = RLP.encodeElement(addr);
        byte[] encNonce = RLP.encodeBigInteger(new BigInteger(1, nonce));
        return HashUtil.sha3omit12(RLP.encodeList(encSender, encNonce));
    }

    public static byte[] doubleDigest(byte[] input) {
        return HashUtil.doubleDigest(input, 0, input.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] doubleDigest(byte[] input, int offset, int length) {
        MessageDigest messageDigest = sha256digest;
        synchronized (messageDigest) {
            sha256digest.reset();
            sha256digest.update(input, offset, length);
            byte[] first = sha256digest.digest();
            return sha256digest.digest(first);
        }
    }

    public static byte[] randomPeerId() {
        byte[] peerIdBytes = new BigInteger(512, Utils.getRandom()).toByteArray();
        String peerId = peerIdBytes.length > 64 ? Hex.toHexString(peerIdBytes, 1, 64) : Hex.toHexString(peerIdBytes);
        return Hex.decode(peerId);
    }

    public static byte[] randomHash() {
        byte[] randomHash = new byte[32];
        Random random = new Random();
        random.nextBytes(randomHash);
        return randomHash;
    }

    public static String shortHash(byte[] hash) {
        return Hex.toHexString(hash).substring(0, 6);
    }

    static {
        try {
            sha256digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

