/*
 * Decompiled with CFR 0.152.
 */
package com.arxanfintech.common.rest;

import com.arxanfintech.common.rest.Request;
import com.arxanfintech.common.structs.Headers;
import com.arxanfintech.common.util.Utils;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.request.HttpRequestWithBody;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;

public class Api {
    public CloseableHttpClient httpclient;
    private String keyStorePath = "";
    private String keyStorePasswd = "";
    private String trustStorePath = "";
    private String trustStorePasswd = "";

    public Api(String keyStorePath, String keyStorePasswd, String trustStorePath, String trustStorePasswd) throws Exception {
        this.keyStorePath = keyStorePath;
        this.keyStorePasswd = keyStorePasswd;
        this.trustStorePath = trustStorePath;
        this.trustStorePasswd = trustStorePasswd;
        this.httpclient = this.NewHttpsClient();
    }

    private CloseableHttpClient NewHttpsClient() throws Exception {
        if (this.httpclient == null) {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(new FileInputStream(this.keyStorePath), this.keyStorePasswd.toCharArray());
            KeyManagerFactory keymg = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keymg.init(keyStore, this.keyStorePasswd.toCharArray());
            KeyStore trustKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustKeyStore.load(new FileInputStream(this.trustStorePath), this.trustStorePasswd.toCharArray());
            TrustManagerFactory trustKeyMg = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustKeyMg.init(trustKeyStore);
            SSLContext sslcontext = SSLContext.getInstance("TLS");
            sslcontext.init(keymg.getKeyManagers(), trustKeyMg.getTrustManagers(), null);
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext);
            this.httpclient = HttpClients.custom().setSSLSocketFactory(sslsf).build();
        }
        return this.httpclient;
    }

    public Api() throws Exception {
        if (this.httpclient == null) {
            SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(null, new TrustSelfSignedStrategy()).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext);
            this.httpclient = HttpClients.custom().setSSLSocketFactory(sslsf).build();
        }
    }

    public String DoGet(Request request) throws Exception {
        try {
            Unirest.setHttpClient(this.httpclient);
            Map<String, String> mapHeader = Utils.JsonToMap(request.header);
            mapHeader.put(Headers.APIKeyHeader, request.client.GetApiKey());
            if (request.client.GetRouteTag() != "") {
                mapHeader.put(Headers.FabioRouteTagHeader, request.client.GetRouteTag());
                mapHeader.put(Headers.RouteTagHeader, request.client.GetRouteTag());
            }
            HttpResponse<String> res = Unirest.get(request.url).headers((Map)mapHeader).asString();
            String respData = res.getBody();
            System.out.println("Got remote cipher response: " + respData);
            String oriData = "";
            oriData = request.client.GetEnableCrypto() != false ? request.crypto.decryptAndVerify(respData.getBytes()) : respData;
            return oriData;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return null;
        }
    }

    public String DoPost(Request request) {
        try {
            Unirest.setHttpClient(this.httpclient);
            String buf = "";
            buf = request.client.GetEnableCrypto() != false ? request.crypto.signAndEncrypt(request.body.toString().getBytes()) : request.body.toString();
            Map<String, String> mapHeader = Utils.JsonToMap(request.header);
            mapHeader.put(Headers.APIKeyHeader, request.client.GetApiKey());
            if (request.client.GetRouteTag() != "") {
                mapHeader.put(Headers.FabioRouteTagHeader, request.client.GetRouteTag());
                mapHeader.put(Headers.RouteTagHeader, request.client.GetRouteTag());
            }
            System.out.println("after sign and encrypt : " + buf);
            HttpResponse<String> res = ((HttpRequestWithBody)Unirest.post(request.url).headers((Map)mapHeader)).body(buf).asString();
            String respData = res.getBody();
            System.out.println("Got remote cipher response: " + respData);
            String oriData = "";
            oriData = request.client.GetEnableCrypto() != false ? request.crypto.decryptAndVerify(respData.getBytes()) : respData;
            return oriData;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return "";
        }
    }

    public String DoPut(Request request) {
        try {
            Unirest.setHttpClient(this.httpclient);
            String buf = "";
            buf = request.client.GetEnableCrypto() != false ? request.crypto.signAndEncrypt(request.body.toString().getBytes()) : request.body.toString();
            Map<String, String> mapHeader = Utils.JsonToMap(request.header);
            mapHeader.put(Headers.APIKeyHeader, request.client.GetApiKey());
            if (request.client.GetRouteTag() != "") {
                mapHeader.put(Headers.FabioRouteTagHeader, request.client.GetRouteTag());
                mapHeader.put(Headers.RouteTagHeader, request.client.GetRouteTag());
            }
            HttpResponse<String> res = ((HttpRequestWithBody)Unirest.put(request.url).headers((Map)mapHeader)).body(buf).asString();
            String respData = res.getBody();
            System.out.println("Got remote cipher response: " + respData);
            String oriData = "";
            oriData = request.client.GetEnableCrypto() != false ? request.crypto.decryptAndVerify(respData.getBytes()) : respData;
            return oriData;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return "";
        }
    }

    public String DoUploadFile(Request request, String filename, String poeid, Boolean readonly) {
        try {
            Unirest.setHttpClient(this.httpclient);
            String buf = "";
            buf = request.client.GetEnableCrypto() != false ? request.crypto.signAndEncrypt(request.body.toString().getBytes()) : request.body.toString();
            Map<String, String> mapHeader = Utils.JsonToMap(request.header);
            mapHeader.put(Headers.APIKeyHeader, request.client.GetApiKey());
            if (request.client.GetRouteTag() != "") {
                mapHeader.put(Headers.FabioRouteTagHeader, request.client.GetRouteTag());
                mapHeader.put(Headers.RouteTagHeader, request.client.GetRouteTag());
            }
            HttpResponse<String> res = ((HttpRequestWithBody)Unirest.post(request.url).headers((Map)mapHeader)).field("poe_id", poeid).field("read_only", readonly).field("poe_file", filename).field("file", new File(filename)).asString();
            String respData = res.getBody();
            System.out.println("Got remote cipher response: " + respData);
            String oriData = "";
            oriData = request.client.GetEnableCrypto() != false ? request.crypto.decryptAndVerify(respData.getBytes()) : respData;
            return oriData;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return "";
        }
    }
}

