/*
 * Decompiled with CFR 0.152.
 */
package com.arxanfintech.common.crypto;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.bouncycastle.util.encoders.Base64;

public class CertTool {
    public static X509Certificate getCertfromPEM(String certFile) throws IOException, CertificateException, NoSuchProviderException {
        FileInputStream inStrm = new FileInputStream(certFile);
        X509Certificate cert = CertTool.getCertfromPEM(inStrm);
        return cert;
    }

    public static X509Certificate getCertfromPEM(byte[] pemBytes) throws IOException, CertificateException, NoSuchProviderException {
        ByteArrayInputStream inStrm = new ByteArrayInputStream(pemBytes);
        X509Certificate cert = CertTool.getCertfromPEM(inStrm);
        return cert;
    }

    public static X509Certificate getCertfromPEM(InputStream certStream) throws IOException, CertificateException, NoSuchProviderException {
        String temp;
        String beginKey = "-----BEGIN CERTIFICATE-----";
        String endKey = "-----END CERTIFICATE-----";
        BufferedReader bufRdr = new BufferedReader(new InputStreamReader(certStream));
        ByteArrayOutputStream ostr = new ByteArrayOutputStream();
        PrintStream opstr = new PrintStream(ostr);
        while ((temp = bufRdr.readLine()) != null && !temp.equals(beginKey)) {
        }
        if (temp == null) {
            throw new IOException("Error in " + certStream.toString() + ", missing " + beginKey + " boundary");
        }
        while ((temp = bufRdr.readLine()) != null && !temp.equals(endKey)) {
            opstr.print(temp);
        }
        if (temp == null) {
            throw new IOException("Error in " + certStream.toString() + ", missing " + endKey + " boundary");
        }
        opstr.close();
        byte[] certbuf = Base64.decode(ostr.toByteArray());
        CertificateFactory cf = CertificateFactory.getInstance("X.509", "SC");
        X509Certificate x509cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certbuf));
        return x509cert;
    }

    public static void main(String[] args) {
    }
}

