/*
 * Decompiled with CFR 0.152.
 */
package com.arxanfintech.common.util;

import com.arxanfintech.common.util.ByteUtil;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Queue;
import org.spongycastle.util.Arrays;
import org.spongycastle.util.BigIntegers;

public class RLP {
    private static final double MAX_ITEM_LENGTH = Math.pow(256.0, 8.0);
    private static final int SIZE_THRESHOLD = 56;
    private static final int OFFSET_SHORT_ITEM = 128;
    private static final int OFFSET_LONG_ITEM = 183;
    private static final int OFFSET_SHORT_LIST = 192;
    private static final int OFFSET_LONG_LIST = 247;

    private static byte decodeOneByteItem(byte[] data, int index) {
        if ((data[index] & 0xFF) == 128) {
            return (byte)(data[index] - 128);
        }
        if ((data[index] & 0xFF) < 128) {
            return data[index];
        }
        if ((data[index] & 0xFF) == 129) {
            return data[index + 1];
        }
        return 0;
    }

    public static int decodeInt(byte[] data, int index) {
        int value = 0;
        if ((data[index] & 0xFF) < 128) {
            return data[index];
        }
        if ((data[index] & 0xFF) >= 128 && (data[index] & 0xFF) < 183) {
            int length = data[index] - 128;
            byte pow = (byte)(length - 1);
            for (int i = 1; i <= length; ++i) {
                value += (data[index + i] & 0xFF) << 8 * pow;
                pow = (byte)(pow - 1);
            }
        } else {
            throw new RuntimeException("wrong decode attempt");
        }
        return value;
    }

    private static short decodeShort(byte[] data, int index) {
        if ((data[index] & 0xFF) > 128 && (data[index] & 0xFF) < 183) {
            byte length = (byte)(data[index] - 128);
            return ByteBuffer.wrap(data, index, length).getShort();
        }
        return data[index];
    }

    private static long decodeLong(byte[] data, int index) {
        long value = 0L;
        if ((data[index] & 0xFF) > 128 && (data[index] & 0xFF) < 183) {
            int length = data[index] - 128;
            byte pow = (byte)(length - 1);
            for (int i = 1; i <= length; ++i) {
                value += (long)((data[index + i] & 0xFF) << 8 * pow);
                pow = (byte)(pow - 1);
            }
        } else {
            throw new RuntimeException("wrong decode attempt");
        }
        return value;
    }

    private static String decodeStringItem(byte[] data, int index) {
        if ((data[index] & 0xFF) >= 183 && (data[index] & 0xFF) < 192) {
            byte lengthOfLength = (byte)(data[index] - 183);
            int length = RLP.calcLengthRaw(lengthOfLength, data, index);
            return new String(data, index + lengthOfLength + 1, length);
        }
        if ((data[index] & 0xFF) > 128 && (data[index] & 0xFF) < 183) {
            byte length = (byte)((data[index] & 0xFF) - 128);
            return new String(data, index + 1, (int)length);
        }
        throw new RuntimeException("wrong decode attempt");
    }

    private static byte[] decodeItemBytes(byte[] data, int index) {
        int length = RLP.calculateLength(data, index);
        byte[] valueBytes = new byte[length];
        System.arraycopy(data, index, valueBytes, 0, length);
        return valueBytes;
    }

    public static BigInteger decodeBigInteger(byte[] data, int index) {
        int length = RLP.calculateLength(data, index);
        byte[] valueBytes = new byte[length];
        System.arraycopy(data, index, valueBytes, 0, length);
        return new BigInteger(1, valueBytes);
    }

    private static byte[] decodeByteArray(byte[] data, int index) {
        int length = RLP.calculateLength(data, index);
        byte[] valueBytes = new byte[length];
        System.arraycopy(data, index, valueBytes, 0, length);
        return valueBytes;
    }

    private static int nextItemLength(byte[] data, int index) {
        if (index >= data.length) {
            return -1;
        }
        if ((data[index] & 0xFF) >= 247) {
            byte lengthOfLength = (byte)(data[index] - 247);
            return RLP.calcLength(lengthOfLength, data, index);
        }
        if ((data[index] & 0xFF) >= 192 && (data[index] & 0xFF) < 247) {
            return (byte)((data[index] & 0xFF) - 192);
        }
        if ((data[index] & 0xFF) > 183 && (data[index] & 0xFF) < 192) {
            byte lengthOfLength = (byte)(data[index] - 183);
            return RLP.calcLength(lengthOfLength, data, index);
        }
        if ((data[index] & 0xFF) > 128 && (data[index] & 0xFF) <= 183) {
            return (byte)((data[index] & 0xFF) - 128);
        }
        if ((data[index] & 0xFF) <= 128) {
            return 1;
        }
        return -1;
    }

    public static byte[] decodeIP4Bytes(byte[] data, int index) {
        int offset = 1;
        byte[] result = new byte[4];
        for (int i = 0; i < 4; ++i) {
            result[i] = RLP.decodeOneByteItem(data, index + offset);
            if ((data[index + offset] & 0xFF) > 128) {
                offset += 2;
                continue;
            }
            ++offset;
        }
        return result;
    }

    public static int getFirstListElement(byte[] payload, int pos) {
        if (pos >= payload.length) {
            return -1;
        }
        if ((payload[pos] & 0xFF) >= 247) {
            byte lengthOfLength = (byte)(payload[pos] - 247);
            return pos + lengthOfLength + 1;
        }
        if ((payload[pos] & 0xFF) >= 192 && (payload[pos] & 0xFF) < 247) {
            return pos + 1;
        }
        if ((payload[pos] & 0xFF) >= 183 && (payload[pos] & 0xFF) < 192) {
            byte lengthOfLength = (byte)(payload[pos] - 183);
            return pos + lengthOfLength + 1;
        }
        return -1;
    }

    public static int getNextElementIndex(byte[] payload, int pos) {
        if (pos >= payload.length) {
            return -1;
        }
        if ((payload[pos] & 0xFF) >= 247) {
            byte lengthOfLength = (byte)(payload[pos] - 247);
            int length = RLP.calcLength(lengthOfLength, payload, pos);
            return pos + lengthOfLength + length + 1;
        }
        if ((payload[pos] & 0xFF) >= 192 && (payload[pos] & 0xFF) < 247) {
            byte length = (byte)((payload[pos] & 0xFF) - 192);
            return pos + 1 + length;
        }
        if ((payload[pos] & 0xFF) >= 183 && (payload[pos] & 0xFF) < 192) {
            byte lengthOfLength = (byte)(payload[pos] - 183);
            int length = RLP.calcLength(lengthOfLength, payload, pos);
            return pos + lengthOfLength + length + 1;
        }
        if ((payload[pos] & 0xFF) > 128 && (payload[pos] & 0xFF) < 183) {
            byte length = (byte)((payload[pos] & 0xFF) - 128);
            return pos + 1 + length;
        }
        if ((payload[pos] & 0xFF) == 128) {
            return pos + 1;
        }
        if ((payload[pos] & 0xFF) < 128) {
            return pos + 1;
        }
        return -1;
    }

    public static void fullTraverse(byte[] msgData, int level, int startPos, int endPos, int levelToIndex, Queue<Integer> index) {
        try {
            if (msgData == null || msgData.length == 0) {
                return;
            }
            int pos = startPos;
            while (pos < endPos) {
                byte length;
                int length2;
                byte lengthOfLength;
                if (level == levelToIndex) {
                    index.add(pos);
                }
                if ((msgData[pos] & 0xFF) >= 247) {
                    lengthOfLength = (byte)(msgData[pos] - 247);
                    length2 = RLP.calcLength(lengthOfLength, msgData, pos);
                    System.out.println("-- level: [" + level + "] Found big list length: " + length2);
                    RLP.fullTraverse(msgData, level + 1, pos + lengthOfLength + 1, pos + lengthOfLength + length2, levelToIndex, index);
                    pos += lengthOfLength + length2 + 1;
                    continue;
                }
                if ((msgData[pos] & 0xFF) >= 192 && (msgData[pos] & 0xFF) < 247) {
                    length = (byte)((msgData[pos] & 0xFF) - 192);
                    System.out.println("-- level: [" + level + "] Found small list length: " + length);
                    RLP.fullTraverse(msgData, level + 1, pos + 1, pos + length + 1, levelToIndex, index);
                    pos += 1 + length;
                    continue;
                }
                if ((msgData[pos] & 0xFF) >= 183 && (msgData[pos] & 0xFF) < 192) {
                    lengthOfLength = (byte)(msgData[pos] - 183);
                    length2 = RLP.calcLength(lengthOfLength, msgData, pos);
                    System.out.println("-- level: [" + level + "] Found big item length: " + length2);
                    pos += lengthOfLength + length2 + 1;
                    continue;
                }
                if ((msgData[pos] & 0xFF) > 128 && (msgData[pos] & 0xFF) < 183) {
                    length = (byte)((msgData[pos] & 0xFF) - 128);
                    System.out.println("-- level: [" + level + "] Found small item length: " + length);
                    pos += 1 + length;
                    continue;
                }
                if ((msgData[pos] & 0xFF) == 128) {
                    System.out.println("-- level: [" + level + "] Found null item: ");
                    ++pos;
                    continue;
                }
                if ((msgData[pos] & 0xFF) >= 128) continue;
                System.out.println("-- level: [" + level + "] Found single item: ");
                ++pos;
            }
        }
        catch (Throwable th) {
            throw new RuntimeException("RLP wrong encoding", th.fillInStackTrace());
        }
    }

    private static int calcLength(int lengthOfLength, byte[] msgData, int pos) {
        byte pow = (byte)(lengthOfLength - 1);
        int length = 0;
        for (int i = 1; i <= lengthOfLength; ++i) {
            length += (msgData[pos + i] & 0xFF) << 8 * pow;
            pow = (byte)(pow - 1);
        }
        return length;
    }

    private static int calcLengthRaw(int lengthOfLength, byte[] msgData, int index) {
        byte pow = (byte)(lengthOfLength - 1);
        int length = 0;
        for (int i = 1; i <= lengthOfLength; ++i) {
            length += msgData[index + i] << 8 * pow;
            pow = (byte)(pow - 1);
        }
        return length;
    }

    public static byte getCommandCode(byte[] data) {
        int index = RLP.getFirstListElement(data, 0);
        byte command = data[index];
        return (command & 0xFF) == 128 ? (byte)0 : command;
    }

    public static byte[] encodeLength(int length, int offset) {
        if (length < 56) {
            byte firstByte = (byte)(length + offset);
            return new byte[]{firstByte};
        }
        if ((double)length < MAX_ITEM_LENGTH) {
            byte[] binaryLength = length > 255 ? ByteUtil.intToBytesNoLeadZeroes(length) : new byte[]{(byte)length};
            byte firstByte = (byte)(binaryLength.length + offset + 56 - 1);
            return Arrays.concatenate(new byte[]{firstByte}, binaryLength);
        }
        throw new RuntimeException("Input too long");
    }

    public static byte[] encodeByte(byte singleByte) {
        if ((singleByte & 0xFF) == 0) {
            return new byte[]{-128};
        }
        if ((singleByte & 0xFF) <= 127) {
            return new byte[]{singleByte};
        }
        return new byte[]{-127, singleByte};
    }

    public static byte[] encodeShort(short singleShort) {
        if ((singleShort & 0xFF) == singleShort) {
            return RLP.encodeByte((byte)singleShort);
        }
        return new byte[]{-126, (byte)(singleShort >> 8 & 0xFF), (byte)(singleShort >> 0 & 0xFF)};
    }

    public static byte[] encodeInt(int singleInt) {
        if ((singleInt & 0xFF) == singleInt) {
            return RLP.encodeByte((byte)singleInt);
        }
        if ((singleInt & 0xFFFF) == singleInt) {
            return RLP.encodeShort((short)singleInt);
        }
        if ((singleInt & 0xFFFFFF) == singleInt) {
            return new byte[]{-125, (byte)(singleInt >>> 16), (byte)(singleInt >>> 8), (byte)singleInt};
        }
        return new byte[]{-124, (byte)(singleInt >>> 24), (byte)(singleInt >>> 16), (byte)(singleInt >>> 8), (byte)singleInt};
    }

    public static byte[] encodeString(String srcString) {
        return RLP.encodeElement(srcString.getBytes());
    }

    public static byte[] encodeBigInteger(BigInteger srcBigInteger) {
        if (srcBigInteger.equals(BigInteger.ZERO)) {
            return RLP.encodeByte((byte)0);
        }
        return RLP.encodeElement(BigIntegers.asUnsignedByteArray(srcBigInteger));
    }

    public static byte[] encodeElement(byte[] srcData) {
        if (ByteUtil.isNullOrZeroArray(srcData)) {
            return new byte[]{-128};
        }
        if (ByteUtil.isSingleZero(srcData)) {
            return srcData;
        }
        if (srcData.length == 1 && (srcData[0] & 0xFF) < 128) {
            return srcData;
        }
        if (srcData.length < 56) {
            byte length = (byte)(128 + srcData.length);
            byte[] data = java.util.Arrays.copyOf(srcData, srcData.length + 1);
            System.arraycopy(data, 0, data, 1, srcData.length);
            data[0] = length;
            return data;
        }
        int byteNum = 0;
        for (int tmpLength = srcData.length; tmpLength != 0; tmpLength >>= 8) {
            byteNum = (byte)(byteNum + 1);
        }
        byte[] lenBytes = new byte[byteNum];
        for (int i = 0; i < byteNum; ++i) {
            lenBytes[byteNum - 1 - i] = (byte)(srcData.length >> 8 * i & 0xFF);
        }
        byte[] data = java.util.Arrays.copyOf(srcData, srcData.length + 1 + byteNum);
        System.arraycopy(data, 0, data, 1 + byteNum, srcData.length);
        data[0] = (byte)(183 + byteNum);
        System.arraycopy(lenBytes, 0, data, 1, lenBytes.length);
        return data;
    }

    public static int calcElementPrefixSize(byte[] srcData) {
        if (ByteUtil.isNullOrZeroArray(srcData)) {
            return 0;
        }
        if (ByteUtil.isSingleZero(srcData)) {
            return 0;
        }
        if (srcData.length == 1 && (srcData[0] & 0xFF) < 128) {
            return 0;
        }
        if (srcData.length < 56) {
            return 1;
        }
        int byteNum = 0;
        for (int tmpLength = srcData.length; tmpLength != 0; tmpLength >>= 8) {
            byteNum = (byte)(byteNum + 1);
        }
        return 1 + byteNum;
    }

    public static byte[] encodeListHeader(int size) {
        byte[] header;
        if (size == 0) {
            return new byte[]{-64};
        }
        int totalLength = size;
        if (totalLength < 56) {
            header = new byte[]{(byte)(192 + totalLength)};
        } else {
            int tmpLength;
            int byteNum = 0;
            for (tmpLength = totalLength; tmpLength != 0; tmpLength >>= 8) {
                byteNum = (byte)(byteNum + 1);
            }
            tmpLength = totalLength;
            byte[] lenBytes = new byte[byteNum];
            for (int i = 0; i < byteNum; ++i) {
                lenBytes[byteNum - 1 - i] = (byte)(tmpLength >> 8 * i & 0xFF);
            }
            header = new byte[1 + lenBytes.length];
            header[0] = (byte)(247 + byteNum);
            System.arraycopy(lenBytes, 0, header, 1, lenBytes.length);
        }
        return header;
    }

    public static byte[] encodeLongElementHeader(int length) {
        if (length < 56) {
            if (length == 0) {
                return new byte[]{-128};
            }
            return new byte[]{(byte)(128 + length)};
        }
        int byteNum = 0;
        for (int tmpLength = length; tmpLength != 0; tmpLength >>= 8) {
            byteNum = (byte)(byteNum + 1);
        }
        byte[] lenBytes = new byte[byteNum];
        for (int i = 0; i < byteNum; ++i) {
            lenBytes[byteNum - 1 - i] = (byte)(length >> 8 * i & 0xFF);
        }
        byte[] header = new byte[1 + lenBytes.length];
        header[0] = (byte)(183 + byteNum);
        System.arraycopy(lenBytes, 0, header, 1, lenBytes.length);
        return header;
    }

    public static byte[] encodeList(byte[] ... elements) {
        int copyPos;
        byte[] data;
        if (elements == null) {
            return new byte[]{-64};
        }
        int totalLength = 0;
        for (byte[] element1 : elements) {
            totalLength += element1.length;
        }
        if (totalLength < 56) {
            data = new byte[1 + totalLength];
            data[0] = (byte)(192 + totalLength);
            copyPos = 1;
        } else {
            int tmpLength;
            int byteNum = 0;
            for (tmpLength = totalLength; tmpLength != 0; tmpLength >>= 8) {
                byteNum = (byte)(byteNum + 1);
            }
            tmpLength = totalLength;
            byte[] lenBytes = new byte[byteNum];
            for (int i = 0; i < byteNum; ++i) {
                lenBytes[byteNum - 1 - i] = (byte)(tmpLength >> 8 * i & 0xFF);
            }
            data = new byte[1 + lenBytes.length + totalLength];
            data[0] = (byte)(247 + byteNum);
            System.arraycopy(lenBytes, 0, data, 1, lenBytes.length);
            copyPos = lenBytes.length + 1;
        }
        for (byte[] element : elements) {
            System.arraycopy(element, 0, data, copyPos, element.length);
            copyPos += element.length;
        }
        return data;
    }

    private static byte[] toBytes(Object input) {
        if (input instanceof byte[]) {
            return (byte[])input;
        }
        if (input instanceof String) {
            String inputString = (String)input;
            return inputString.getBytes();
        }
        if (input instanceof Long) {
            Long inputLong = (Long)input;
            return inputLong == 0L ? ByteUtil.EMPTY_BYTE_ARRAY : BigIntegers.asUnsignedByteArray(BigInteger.valueOf(inputLong));
        }
        if (input instanceof Integer) {
            Integer inputInt = (Integer)input;
            return inputInt == 0 ? ByteUtil.EMPTY_BYTE_ARRAY : BigIntegers.asUnsignedByteArray(BigInteger.valueOf(inputInt.intValue()));
        }
        if (input instanceof BigInteger) {
            BigInteger inputBigInt = (BigInteger)input;
            return inputBigInt.equals(BigInteger.ZERO) ? ByteUtil.EMPTY_BYTE_ARRAY : BigIntegers.asUnsignedByteArray(inputBigInt);
        }
        throw new RuntimeException("Unsupported type: Only accepting String, Integer and BigInteger for now");
    }

    private static int calculateLength(byte[] data, int index) {
        if ((data[index] & 0xFF) >= 183 && (data[index] & 0xFF) < 192) {
            byte lengthOfLength = (byte)(data[index] - 183);
            return RLP.calcLengthRaw(lengthOfLength, data, index);
        }
        if ((data[index] & 0xFF) > 128 && (data[index] & 0xFF) < 183) {
            return (byte)(data[index] - 128);
        }
        throw new RuntimeException("wrong decode attempt");
    }
}

