/*
 * Decompiled with CFR 0.152.
 */
package com.arxanfintech.common.crypto.core;

import com.arxanfintech.common.crypto.core.ArxanIESEngine;
import com.arxanfintech.common.crypto.core.ConcatKDFBytesGenerator;
import com.arxanfintech.common.crypto.core.ECIESPublicKeyEncoder;
import com.arxanfintech.common.crypto.core.ECKey;
import com.arxanfintech.common.crypto.core.MGF1BytesGeneratorExt;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.spongycastle.crypto.AsymmetricCipherKeyPair;
import org.spongycastle.crypto.BufferedBlockCipher;
import org.spongycastle.crypto.CipherParameters;
import org.spongycastle.crypto.InvalidCipherTextException;
import org.spongycastle.crypto.agreement.ECDHBasicAgreement;
import org.spongycastle.crypto.digests.SHA1Digest;
import org.spongycastle.crypto.digests.SHA256Digest;
import org.spongycastle.crypto.engines.AESFastEngine;
import org.spongycastle.crypto.generators.ECKeyPairGenerator;
import org.spongycastle.crypto.generators.EphemeralKeyPairGenerator;
import org.spongycastle.crypto.macs.HMac;
import org.spongycastle.crypto.modes.SICBlockCipher;
import org.spongycastle.crypto.params.AsymmetricKeyParameter;
import org.spongycastle.crypto.params.ECKeyGenerationParameters;
import org.spongycastle.crypto.params.ECPrivateKeyParameters;
import org.spongycastle.crypto.params.ECPublicKeyParameters;
import org.spongycastle.crypto.params.IESParameters;
import org.spongycastle.crypto.params.IESWithCipherParameters;
import org.spongycastle.crypto.params.ParametersWithIV;
import org.spongycastle.crypto.parsers.ECIESPublicKeyParser;
import org.spongycastle.math.ec.ECPoint;

public class ECIESCoder {
    public static final int KEY_SIZE = 128;

    public static byte[] decrypt(BigInteger privKey, byte[] cipher) throws IOException, InvalidCipherTextException {
        return ECIESCoder.decrypt(privKey, cipher, null);
    }

    public static byte[] decrypt(BigInteger privKey, byte[] cipher, byte[] macData) throws IOException, InvalidCipherTextException {
        ByteArrayInputStream is = new ByteArrayInputStream(cipher);
        byte[] ephemBytes = new byte[2 * ((ECKey.CURVE.getCurve().getFieldSize() + 7) / 8) + 1];
        is.read(ephemBytes);
        ECPoint ephem = ECKey.CURVE.getCurve().decodePoint(ephemBytes);
        byte[] IV = new byte[16];
        is.read(IV);
        byte[] cipherBody = new byte[is.available()];
        is.read(cipherBody);
        byte[] plaintext = ECIESCoder.decrypt(ephem, privKey, IV, cipherBody, macData);
        return plaintext;
    }

    public static byte[] decrypt(ECPoint ephem, BigInteger prv, byte[] IV, byte[] cipher, byte[] macData) throws InvalidCipherTextException {
        AESFastEngine aesFastEngine = new AESFastEngine();
        ArxanIESEngine iesEngine = new ArxanIESEngine(new ECDHBasicAgreement(), new ConcatKDFBytesGenerator(new SHA256Digest()), new HMac(new SHA256Digest()), new SHA256Digest(), new BufferedBlockCipher(new SICBlockCipher(aesFastEngine)));
        byte[] d = new byte[]{};
        byte[] e = new byte[]{};
        IESWithCipherParameters p = new IESWithCipherParameters(d, e, 128, 128);
        ParametersWithIV parametersWithIV = new ParametersWithIV(p, IV);
        iesEngine.init(false, new ECPrivateKeyParameters(prv, ECKey.CURVE), new ECPublicKeyParameters(ephem, ECKey.CURVE), parametersWithIV);
        return iesEngine.processBlock(cipher, 0, cipher.length, macData);
    }

    public static byte[] decryptSimple(BigInteger privKey, byte[] cipher) throws IOException, InvalidCipherTextException {
        ArxanIESEngine iesEngine = new ArxanIESEngine(new ECDHBasicAgreement(), new MGF1BytesGeneratorExt(new SHA1Digest(), 1), new HMac(new SHA1Digest()), new SHA1Digest(), null);
        IESParameters p = new IESParameters(null, null, 128);
        ParametersWithIV parametersWithIV = new ParametersWithIV(p, new byte[0]);
        iesEngine.setHashMacKey(false);
        iesEngine.init((AsymmetricKeyParameter)new ECPrivateKeyParameters(privKey, ECKey.CURVE), (CipherParameters)parametersWithIV, new ECIESPublicKeyParser(ECKey.CURVE));
        return iesEngine.processBlock(cipher, 0, cipher.length);
    }

    public static byte[] encrypt(ECPoint toPub, byte[] plaintext) throws InvalidCipherTextException, IOException {
        return ECIESCoder.encrypt(toPub, plaintext, null);
    }

    public static byte[] encrypt(ECPoint toPub, byte[] plaintext, byte[] macData) throws InvalidCipherTextException, IOException {
        ECKeyPairGenerator eGen = new ECKeyPairGenerator();
        SecureRandom random = new SecureRandom();
        ECKeyGenerationParameters gParam = new ECKeyGenerationParameters(ECKey.CURVE, random);
        eGen.init(gParam);
        byte[] IV = new byte[16];
        new SecureRandom().nextBytes(IV);
        AsymmetricCipherKeyPair ephemPair = eGen.generateKeyPair();
        BigInteger prv = ((ECPrivateKeyParameters)ephemPair.getPrivate()).getD();
        ECPoint pub = ((ECPublicKeyParameters)ephemPair.getPublic()).getQ();
        ArxanIESEngine iesEngine = ECIESCoder.makeIESEngine(true, toPub, prv, IV);
        ECKeyGenerationParameters keygenParams = new ECKeyGenerationParameters(ECKey.CURVE, random);
        ECKeyPairGenerator generator = new ECKeyPairGenerator();
        generator.init(keygenParams);
        ECKeyPairGenerator gen = new ECKeyPairGenerator();
        gen.init(new ECKeyGenerationParameters(ECKey.CURVE, random));
        try {
            byte[] cipher = iesEngine.processBlock(plaintext, 0, plaintext.length, macData);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] pk = pub.getEncoded(false);
            bos.write(pk);
            bos.write(IV);
            bos.write(cipher);
            return bos.toByteArray();
        }
        catch (InvalidCipherTextException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
    }

    public static byte[] encryptSimple(ECPoint pub, byte[] plaintext) throws IOException, InvalidCipherTextException {
        ArxanIESEngine iesEngine = new ArxanIESEngine(new ECDHBasicAgreement(), new MGF1BytesGeneratorExt(new SHA1Digest(), 1), new HMac(new SHA1Digest()), new SHA1Digest(), null);
        IESParameters p = new IESParameters(null, null, 128);
        ParametersWithIV parametersWithIV = new ParametersWithIV(p, new byte[0]);
        iesEngine.setHashMacKey(false);
        ECKeyPairGenerator eGen = new ECKeyPairGenerator();
        SecureRandom random = new SecureRandom();
        ECKeyGenerationParameters gParam = new ECKeyGenerationParameters(ECKey.CURVE, random);
        eGen.init(gParam);
        EphemeralKeyPairGenerator ephemeralKeyPairGenerator = new EphemeralKeyPairGenerator(eGen, new ECIESPublicKeyEncoder());
        iesEngine.init((AsymmetricKeyParameter)new ECPublicKeyParameters(pub, ECKey.CURVE), (CipherParameters)parametersWithIV, ephemeralKeyPairGenerator);
        return iesEngine.processBlock(plaintext, 0, plaintext.length);
    }

    private static ArxanIESEngine makeIESEngine(boolean isEncrypt, ECPoint pub, BigInteger prv, byte[] IV) {
        AESFastEngine aesFastEngine = new AESFastEngine();
        ArxanIESEngine iesEngine = new ArxanIESEngine(new ECDHBasicAgreement(), new ConcatKDFBytesGenerator(new SHA256Digest()), new HMac(new SHA256Digest()), new SHA256Digest(), new BufferedBlockCipher(new SICBlockCipher(aesFastEngine)));
        byte[] d = new byte[]{};
        byte[] e = new byte[]{};
        IESWithCipherParameters p = new IESWithCipherParameters(d, e, 128, 128);
        ParametersWithIV parametersWithIV = new ParametersWithIV(p, IV);
        iesEngine.init(isEncrypt, new ECPrivateKeyParameters(prv, ECKey.CURVE), new ECPublicKeyParameters(pub, ECKey.CURVE), parametersWithIV);
        return iesEngine;
    }

    public static int getOverhead() {
        return 113;
    }
}

