/*
 * Decompiled with CFR 0.152.
 */
package com.arxanfintech.common.crypto.core;

import com.arxanfintech.common.crypto.core.MGF1BytesGeneratorExt;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import org.spongycastle.crypto.BasicAgreement;
import org.spongycastle.crypto.BufferedBlockCipher;
import org.spongycastle.crypto.CipherParameters;
import org.spongycastle.crypto.DerivationFunction;
import org.spongycastle.crypto.DerivationParameters;
import org.spongycastle.crypto.Digest;
import org.spongycastle.crypto.EphemeralKeyPair;
import org.spongycastle.crypto.InvalidCipherTextException;
import org.spongycastle.crypto.KeyParser;
import org.spongycastle.crypto.Mac;
import org.spongycastle.crypto.generators.EphemeralKeyPairGenerator;
import org.spongycastle.crypto.params.AsymmetricKeyParameter;
import org.spongycastle.crypto.params.IESParameters;
import org.spongycastle.crypto.params.IESWithCipherParameters;
import org.spongycastle.crypto.params.KDFParameters;
import org.spongycastle.crypto.params.KeyParameter;
import org.spongycastle.crypto.params.MGFParameters;
import org.spongycastle.crypto.params.ParametersWithIV;
import org.spongycastle.util.Arrays;
import org.spongycastle.util.BigIntegers;
import org.spongycastle.util.Pack;

public class ArxanIESEngine {
    private final Digest hash;
    BasicAgreement agree;
    DerivationFunction kdf;
    Mac mac;
    BufferedBlockCipher cipher;
    byte[] macBuf;
    boolean forEncryption;
    CipherParameters privParam;
    CipherParameters pubParam;
    IESParameters param;
    byte[] V;
    private EphemeralKeyPairGenerator keyPairGenerator;
    private KeyParser keyParser;
    private byte[] IV;
    boolean hashK2 = true;

    public ArxanIESEngine(BasicAgreement agree, DerivationFunction kdf, Mac mac, Digest hash, BufferedBlockCipher cipher) {
        this.agree = agree;
        this.kdf = kdf;
        this.mac = mac;
        this.hash = hash;
        this.macBuf = new byte[mac.getMacSize()];
        this.cipher = cipher;
    }

    public void setHashMacKey(boolean hashK2) {
        this.hashK2 = hashK2;
    }

    public void init(boolean forEncryption, CipherParameters privParam, CipherParameters pubParam, CipherParameters params) {
        this.forEncryption = forEncryption;
        this.privParam = privParam;
        this.pubParam = pubParam;
        this.V = new byte[0];
        this.extractParams(params);
    }

    public void init(AsymmetricKeyParameter publicKey, CipherParameters params, EphemeralKeyPairGenerator ephemeralKeyPairGenerator) {
        this.forEncryption = true;
        this.pubParam = publicKey;
        this.keyPairGenerator = ephemeralKeyPairGenerator;
        this.extractParams(params);
    }

    public void init(AsymmetricKeyParameter privateKey, CipherParameters params, KeyParser publicKeyParser) {
        this.forEncryption = false;
        this.privParam = privateKey;
        this.keyParser = publicKeyParser;
        this.extractParams(params);
    }

    private void extractParams(CipherParameters params) {
        if (params instanceof ParametersWithIV) {
            this.IV = ((ParametersWithIV)params).getIV();
            this.param = (IESParameters)((ParametersWithIV)params).getParameters();
        } else {
            this.IV = null;
            this.param = (IESParameters)params;
        }
    }

    public BufferedBlockCipher getCipher() {
        return this.cipher;
    }

    public Mac getMac() {
        return this.mac;
    }

    private byte[] encryptBlock(byte[] in, int inOff, int inLen, byte[] macData) throws InvalidCipherTextException {
        byte[] K2a;
        int len;
        byte[] C = null;
        byte[] K = null;
        byte[] K1 = null;
        byte[] K2 = null;
        if (this.cipher == null) {
            K1 = new byte[inLen];
            K2 = new byte[this.param.getMacKeySize() / 8];
            K = new byte[K1.length + K2.length];
            this.kdf.generateBytes(K, 0, K.length);
            System.arraycopy(K, 0, K1, 0, K1.length);
            System.arraycopy(K, inLen, K2, 0, K2.length);
            C = new byte[inLen];
            for (int i = 0; i != inLen; ++i) {
                C[i] = (byte)(in[inOff + i] ^ K1[i]);
            }
            len = inLen;
        } else {
            K1 = new byte[((IESWithCipherParameters)this.param).getCipherKeySize() / 8];
            K2 = new byte[this.param.getMacKeySize() / 8];
            K = new byte[K1.length + K2.length];
            this.kdf.generateBytes(K, 0, K.length);
            System.arraycopy(K, 0, K1, 0, K1.length);
            System.arraycopy(K, K1.length, K2, 0, K2.length);
            if (this.IV != null) {
                this.cipher.init(true, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(K1), this.IV));
            } else {
                this.cipher.init(true, (CipherParameters)new KeyParameter(K1));
            }
            C = new byte[this.cipher.getOutputSize(inLen)];
            len = this.cipher.processBytes(in, inOff, inLen, C, 0);
            len += this.cipher.doFinal(C, len);
        }
        byte[] P2 = this.param.getEncodingV();
        byte[] T = new byte[this.mac.getMacSize()];
        if (this.hashK2) {
            K2a = new byte[this.hash.getDigestSize()];
            this.hash.reset();
            this.hash.update(K2, 0, K2.length);
            this.hash.doFinal(K2a, 0);
        } else {
            K2a = K2;
        }
        this.mac.init((CipherParameters)new KeyParameter(K2a));
        this.mac.update(this.IV, 0, this.IV.length);
        this.mac.update(C, 0, C.length);
        if (P2 != null) {
            this.mac.update(P2, 0, P2.length);
        }
        if (this.V.length != 0 && P2 != null) {
            byte[] L2 = new byte[4];
            Pack.intToBigEndian((int)(P2.length * 8), (byte[])L2, (int)0);
            this.mac.update(L2, 0, L2.length);
        }
        if (macData != null) {
            this.mac.update(macData, 0, macData.length);
        }
        this.mac.doFinal(T, 0);
        byte[] Output = new byte[this.V.length + len + T.length];
        System.arraycopy(this.V, 0, Output, 0, this.V.length);
        System.arraycopy(C, 0, Output, this.V.length, len);
        System.arraycopy(T, 0, Output, this.V.length + len, T.length);
        return Output;
    }

    private byte[] decryptBlock(byte[] in_enc, int inOff, int inLen, byte[] macData) throws InvalidCipherTextException {
        byte[] K2a;
        int len;
        byte[] M = null;
        byte[] K = null;
        byte[] K1 = null;
        byte[] K2 = null;
        if (inLen <= this.param.getMacKeySize() / 8) {
            throw new InvalidCipherTextException("Length of input must be greater than the MAC");
        }
        if (this.cipher == null) {
            K1 = new byte[inLen - this.V.length - this.mac.getMacSize()];
            K2 = new byte[this.param.getMacKeySize() / 8];
            K = new byte[K1.length + K2.length];
            this.kdf.generateBytes(K, 0, K.length);
            System.arraycopy(K, 0, K1, 0, K1.length);
            System.arraycopy(K, K1.length, K2, 0, K2.length);
            M = new byte[K1.length];
            for (int i = 0; i != K1.length; ++i) {
                M[i] = (byte)(in_enc[inOff + this.V.length + i] ^ K1[i]);
            }
            len = K1.length;
        } else {
            K1 = new byte[((IESWithCipherParameters)this.param).getCipherKeySize() / 8];
            K2 = new byte[this.param.getMacKeySize() / 8];
            K = new byte[K1.length + K2.length];
            this.kdf.generateBytes(K, 0, K.length);
            System.arraycopy(K, 0, K1, 0, K1.length);
            System.arraycopy(K, K1.length, K2, 0, K2.length);
            if (this.IV != null) {
                this.cipher.init(false, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(K1), this.IV));
            } else {
                this.cipher.init(false, (CipherParameters)new KeyParameter(K1));
            }
            M = new byte[this.cipher.getOutputSize(inLen - this.V.length - this.mac.getMacSize())];
            len = this.cipher.processBytes(in_enc, inOff + this.V.length, inLen - this.V.length - this.mac.getMacSize(), M, 0);
            len += this.cipher.doFinal(M, len);
        }
        byte[] P2 = this.param.getEncodingV();
        int end = inOff + inLen;
        byte[] T1 = Arrays.copyOfRange((byte[])in_enc, (int)(end - this.mac.getMacSize()), (int)end);
        byte[] T2 = new byte[T1.length];
        if (this.hashK2) {
            K2a = new byte[this.hash.getDigestSize()];
            this.hash.reset();
            this.hash.update(K2, 0, K2.length);
            this.hash.doFinal(K2a, 0);
        } else {
            K2a = K2;
        }
        this.mac.init((CipherParameters)new KeyParameter(K2a));
        this.mac.update(this.IV, 0, this.IV.length);
        this.mac.update(in_enc, inOff + this.V.length, inLen - this.V.length - T2.length);
        if (P2 != null) {
            this.mac.update(P2, 0, P2.length);
        }
        if (this.V.length != 0 && P2 != null) {
            byte[] L2 = new byte[4];
            Pack.intToBigEndian((int)(P2.length * 8), (byte[])L2, (int)0);
            this.mac.update(L2, 0, L2.length);
        }
        if (macData != null) {
            this.mac.update(macData, 0, macData.length);
        }
        this.mac.doFinal(T2, 0);
        if (!Arrays.constantTimeAreEqual((byte[])T1, (byte[])T2)) {
            throw new InvalidCipherTextException("Invalid MAC.");
        }
        return Arrays.copyOfRange((byte[])M, (int)0, (int)len);
    }

    public byte[] processBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        return this.processBlock(in, inOff, inLen, null);
    }

    public byte[] processBlock(byte[] in, int inOff, int inLen, byte[] macData) throws InvalidCipherTextException {
        byte[] Z;
        if (this.forEncryption) {
            if (this.keyPairGenerator != null) {
                EphemeralKeyPair ephKeyPair = this.keyPairGenerator.generate();
                this.privParam = ephKeyPair.getKeyPair().getPrivate();
                this.V = ephKeyPair.getEncodedPublicKey();
            }
        } else if (this.keyParser != null) {
            ByteArrayInputStream bIn = new ByteArrayInputStream(in, inOff, inLen);
            try {
                this.pubParam = this.keyParser.readKey((InputStream)bIn);
            }
            catch (IOException e) {
                throw new InvalidCipherTextException("unable to recover ephemeral public key: " + e.getMessage(), (Throwable)e);
            }
            int encLength = inLen - bIn.available();
            this.V = Arrays.copyOfRange((byte[])in, (int)inOff, (int)(inOff + encLength));
        }
        this.agree.init(this.privParam);
        BigInteger z = this.agree.calculateAgreement(this.pubParam);
        byte[] VZ = Z = BigIntegers.asUnsignedByteArray((int)this.agree.getFieldSize(), (BigInteger)z);
        Object kdfParam = this.kdf instanceof MGF1BytesGeneratorExt ? new MGFParameters(VZ) : new KDFParameters(VZ, this.param.getDerivationV());
        this.kdf.init((DerivationParameters)kdfParam);
        return this.forEncryption ? this.encryptBlock(in, inOff, inLen, macData) : this.decryptBlock(in, inOff, inLen, macData);
    }
}

