/*
 * Decompiled with CFR 0.152.
 */
package com.arxanfintech.common.rest;

import com.arxanfintech.common.rest.Request;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import javax.net.ssl.SSLContext;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;

public class Api {
    public CloseableHttpClient httpclient;

    public CloseableHttpClient NewHttpClient() throws Exception {
        if (this.httpclient == null) {
            SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(null, new TrustSelfSignedStrategy()).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext);
            CloseableHttpClient closeableHttpClient = HttpClients.custom().setSSLSocketFactory(sslsf).build();
        }
        return this.httpclient;
    }

    public String DoGet(Request request) throws Exception {
        try {
            SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(null, new TrustSelfSignedStrategy()).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext);
            CloseableHttpClient httpclient = HttpClients.custom().setSSLSocketFactory(sslsf).build();
            Unirest.setHttpClient(httpclient);
            HttpResponse<String> res = Unirest.get(request.url).header("Callback-Url", request.header.getString("Callback-Url")).header("Bc-Invoke-Mode", request.header.getString("Bc-Invoke-Mode")).header("API-Key", request.client.ApiKey).asString();
            String respData = res.getBody();
            System.out.println("Got remote cipher response: " + respData);
            String oriData = request.crypto.decryptAndVerify(respData.getBytes());
            return oriData;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return null;
        }
    }

    public String DoPost(Request request) {
        try {
            SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(null, new TrustSelfSignedStrategy()).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext);
            CloseableHttpClient httpclient = HttpClients.custom().setSSLSocketFactory(sslsf).build();
            Unirest.setHttpClient(httpclient);
            String buf = request.crypto.signAndEncrypt(request.body.toString().getBytes());
            System.out.println("after sign and encrypt : " + buf);
            HttpResponse<String> res = Unirest.post(request.url).header("API-Key", request.client.ApiKey).header("Callback-Url", request.header.getString("Callback-Url")).header("Bc-Invoke-Mode", request.header.getString("Bc-Invoke-Mode")).body(buf).asString();
            String respData = res.getBody();
            System.out.println("Got remote cipher response: " + respData);
            String oriData = request.crypto.decryptAndVerify(respData.getBytes());
            return oriData;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return "";
        }
    }

    public String DoPut(Request request) {
        try {
            SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(null, new TrustSelfSignedStrategy()).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext);
            CloseableHttpClient httpclient = HttpClients.custom().setSSLSocketFactory(sslsf).build();
            Unirest.setHttpClient(httpclient);
            String buf = request.crypto.signAndEncrypt(request.body.toString().getBytes());
            HttpResponse<String> res = Unirest.put(request.url).header("API-Key", request.client.ApiKey).header("Callback-Url", request.header.getString("Callback-Url")).header("Bc-Invoke-Mode", request.header.getString("Bc-Invoke-Mode")).body(buf).asString();
            String respData = res.getBody();
            System.out.println("Got remote cipher response: " + respData);
            String oriData = request.crypto.decryptAndVerify(respData.getBytes());
            return oriData;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return "";
        }
    }
}

