/*
 * Decompiled with CFR 0.152.
 */
package com.arvin.gifloader.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Movie;
import android.os.Build;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import java.io.InputStream;

public class GifView
extends ImageView {
    private static final String TAG = "ImageView";
    private static final int DEFAULT_MOVIEW_DURATION = 2000;
    private int mMovieResourceId;
    private Movie mMovie;
    private long mMovieStart;
    private int mCurrentAnimationTime;
    private float mLeft;
    private float mTop;
    private int mMeasureWidth;
    private int mMeasureHeight;
    private float mScale = 1.0f;
    private float mScaleRate = 1.0f;
    private volatile boolean mPaused;
    private boolean mVisible = true;

    public GifView(Context context) {
        this(context, null);
    }

    public GifView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public GifView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setViewAttributes();
    }

    @SuppressLint(value={"NewApi"})
    public void setViewAttributes() {
        if (Build.VERSION.SDK_INT >= 11) {
            this.setLayerType(1, null);
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        Log.e((String)TAG, (String)"--ondraw");
        if (this.mMovie != null) {
            if (!this.mPaused) {
                this.updateAnimationTime();
                this.drawMovieFrame(canvas);
                this.invalidateView();
            } else {
                this.drawMovieFrame(canvas);
            }
        }
    }

    private void drawMovieFrame(Canvas canvas) {
        this.mMovie.setTime(this.mCurrentAnimationTime);
        canvas.save(1);
        canvas.scale(this.mScale, this.mScale);
        this.mMovie.draw(canvas, this.mLeft / this.mScale, this.mTop / this.mScale);
        canvas.restore();
    }

    private void updateAnimationTime() {
        int dur;
        long now = SystemClock.uptimeMillis();
        if (this.mMovieStart == 0L) {
            this.mMovieStart = now;
        }
        if ((dur = this.mMovie.duration()) == 0) {
            dur = 2000;
        }
        this.mCurrentAnimationTime = (int)((now - this.mMovieStart) % (long)dur);
    }

    @SuppressLint(value={"NewApi"})
    private void invalidateView() {
        if (this.mVisible) {
            if (Build.VERSION.SDK_INT >= 16) {
                this.postInvalidateOnAnimation();
            } else {
                this.invalidate();
            }
        }
    }

    @SuppressLint(value={"NewApi"})
    public void onScreenStateChanged(int screenState) {
        super.onScreenStateChanged(screenState);
        this.mVisible = screenState == 1;
        this.invalidateView();
    }

    @SuppressLint(value={"NewApi"})
    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        this.mVisible = visibility == 0;
        this.invalidateView();
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        this.mVisible = visibility == 0;
        this.invalidateView();
    }

    public void setMovieResource(int movieResId) {
        this.mMovieResourceId = movieResId;
        this.mMovie = Movie.decodeStream((InputStream)this.getResources().openRawResource(this.mMovieResourceId));
        this.requestLayout();
    }

    public void setMovie(Movie movie) {
        this.mMovie = movie;
        this.setScale();
        this.invalidate();
    }

    private void setScale() {
        if (this.mMovie != null) {
            float scaleW = (float)this.getWidth() / (float)this.mMovie.width();
            float scaleH = (float)this.getHeight() / (float)this.mMovie.height();
            this.mScale = Math.min(scaleH, scaleW);
        }
    }

    public void setMovieTime(int time) {
        this.mCurrentAnimationTime = time;
        this.invalidate();
    }

    public void setPaused(boolean paused) {
        this.mPaused = paused;
        if (!paused) {
            this.mMovieStart = SystemClock.uptimeMillis() - (long)this.mCurrentAnimationTime;
        }
        this.invalidate();
    }

    public boolean isPaused() {
        return this.mPaused;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (changed && this.mMovie != null) {
            float scaleW = (float)this.getWidth() / (float)this.mMovie.width();
            float scaleH = (float)this.getHeight() / (float)this.mMovie.height();
            this.mScale = Math.min(scaleH, scaleW);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mMovie != null) {
            Log.e((String)TAG, (String)("---moviewidth   sss" + this.mMovie.width()));
            int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
            int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
            int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
            if (widthMode == Integer.MIN_VALUE) {
                Log.e((String)TAG, (String)("---moviewidth before" + this.mMovie.width()));
                int movieWidth = this.mMovie.width();
                this.mMeasureWidth = Math.min(movieWidth, widthSize);
                Log.e((String)TAG, (String)("---moviewidth after" + this.mMovie.width()));
            } else {
                this.mMeasureWidth = widthSize;
            }
            if (heightMode == Integer.MIN_VALUE) {
                Log.e((String)TAG, (String)("---height " + this.mMovie.height()));
                int movieHieght = this.mMovie.height();
                this.mMeasureHeight = Math.min(movieHieght, heightSize);
            } else {
                this.mMeasureHeight = heightSize;
            }
            Log.e((String)TAG, (String)("--wi : " + this.mMeasureWidth + "  h  : " + this.mMeasureHeight));
            this.setMeasuredDimension(this.mMeasureWidth, this.mMeasureHeight);
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }
}

