/*
 * Decompiled with CFR 0.152.
 */
package com.arvin.gifloader.utils;

import android.util.Log;
import android.view.ViewGroup;
import com.arvin.gifloader.widget.GifView;
import java.lang.reflect.Field;

public class GifViewHelper {
    private static int DEFAULT_WIDTH = 200;
    private static int DEFAULT_HEIGHT = 200;

    public static int getImageViewWidth(GifView gifView) {
        if (gifView != null) {
            ViewGroup.LayoutParams params = gifView.getLayoutParams();
            int width = 0;
            if (params != null && params.width != -2) {
                width = gifView.getWidth();
            }
            if (width <= 0 && params != null) {
                width = params.width;
            }
            if (width <= 0) {
                width = GifViewHelper.getImageViewFieldValue((Object)gifView, "mMaxWidth");
            }
            return width;
        }
        return DEFAULT_WIDTH;
    }

    public static int getImageViewHeight(GifView imageView) {
        if (imageView != null) {
            ViewGroup.LayoutParams params = imageView.getLayoutParams();
            int height = 0;
            if (params != null && params.height != -2) {
                height = imageView.getHeight();
            }
            if (height <= 0 && params != null) {
                height = params.height;
            }
            if (height <= 0) {
                height = GifViewHelper.getImageViewFieldValue((Object)imageView, "mMaxHeight");
            }
            return height;
        }
        return DEFAULT_HEIGHT;
    }

    private static int getImageViewFieldValue(Object object, String fieldName) {
        int value = 0;
        try {
            Field field = GifView.class.getDeclaredField(fieldName);
            field.setAccessible(true);
            int fieldValue = (Integer)field.get(object);
            if (fieldValue > 0 && fieldValue < Integer.MAX_VALUE) {
                value = fieldValue;
            }
        }
        catch (Exception e) {
            Log.e((String)"", (String)e.getMessage());
        }
        return value;
    }
}

