/*
 * Decompiled with CFR 0.152.
 */
package com.arvin.gifloader.request;

import com.arvin.gifloader.config.DisplayConfig;
import com.arvin.gifloader.core.GifLoader;
import com.arvin.gifloader.policy.LoadPolicy;
import com.arvin.gifloader.utils.GifViewHelper;
import com.arvin.gifloader.utils.MD5Helper;
import com.arvin.gifloader.widget.GifView;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;

public class GifRequest
implements Comparable<GifRequest> {
    private Reference<GifView> mGifViewRef;
    public DisplayConfig displayConfig;
    public String gifUrl = "";
    public String gifUrlMd5 = "";
    public int serialNum = 0;
    public boolean isCancel = false;
    public boolean justCacheInMem = false;
    LoadPolicy mLoadPolicy;
    public GifLoader.GifListener mGifLister;

    public GifRequest(GifView gifview, DisplayConfig displayConfig, String gifUrl, GifLoader.GifListener listener) {
        this.mLoadPolicy = GifLoader.getInstance().getConfig().loadPolicy;
        this.mGifViewRef = new WeakReference<GifView>(gifview);
        this.displayConfig = displayConfig;
        this.gifUrl = gifUrl;
        gifview.setTag(gifUrl);
        this.gifUrlMd5 = MD5Helper.generateMD5(gifUrl);
        this.mGifLister = listener;
    }

    public void setLoadPolicy(LoadPolicy policy) {
        if (policy != null) {
            this.mLoadPolicy = policy;
        }
    }

    public boolean isGifViewTagValid() {
        return this.mGifViewRef.get() != null ? this.mGifViewRef.get().getTag().equals(this.gifUrl) : false;
    }

    public GifView getGifView() {
        return this.mGifViewRef.get();
    }

    public int getGifViewWidth() {
        return GifViewHelper.getImageViewWidth(this.mGifViewRef.get());
    }

    public int getGifViewHeight() {
        return GifViewHelper.getImageViewHeight(this.mGifViewRef.get());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.gifUrl == null ? 0 : this.gifUrl.hashCode());
        result = 31 * result + (this.mGifViewRef == null ? 0 : ((Object)((Object)this.mGifViewRef.get())).hashCode());
        result = 31 * result + this.serialNum;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GifRequest other = (GifRequest)obj;
        if (this.gifUrl == null ? other.gifUrl != null : !this.gifUrl.equals(other.gifUrl)) {
            return false;
        }
        if (this.mGifViewRef == null ? other.mGifViewRef != null : !((Object)((Object)this.mGifViewRef.get())).equals((Object)other.mGifViewRef.get())) {
            return false;
        }
        return this.serialNum == other.serialNum;
    }

    @Override
    public int compareTo(GifRequest another) {
        return this.mLoadPolicy.compare(this, another);
    }
}

