/*
 * Decompiled with CFR 0.152.
 */
package com.arvin.gifloader.loader;

import com.arvin.gifloader.loader.Loader;
import com.arvin.gifloader.loader.LocalLoader;
import com.arvin.gifloader.loader.NullLoader;
import com.arvin.gifloader.loader.UrlLoader;
import java.util.HashMap;
import java.util.Map;

public class LoaderManager {
    public static final String HTTP = "http";
    public static final String HTTPS = "https";
    public static final String FILE = "file";
    private Map<String, Loader> mLoaderMap = new HashMap<String, Loader>();
    private Loader mNullLoader = new NullLoader();
    private static LoaderManager INSTANCE;

    private LoaderManager() {
        this.register(HTTP, new UrlLoader());
        this.register(HTTPS, new UrlLoader());
        this.register(FILE, new LocalLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LoaderManager getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<LoaderManager> clazz = LoaderManager.class;
        synchronized (LoaderManager.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new LoaderManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public final synchronized void register(String schema, Loader loader) {
        this.mLoaderMap.put(schema, loader);
    }

    public Loader getLoader(String schema) {
        if (this.mLoaderMap.containsKey(schema)) {
            return this.mLoaderMap.get(schema);
        }
        return this.mNullLoader;
    }
}

