/*
 * Decompiled with CFR 0.152.
 */
package com.arvin.gifloader.loader;

import android.graphics.Movie;
import android.util.Log;
import com.arvin.gifloader.cache.GifCache;
import com.arvin.gifloader.config.DisplayConfig;
import com.arvin.gifloader.core.GifLoader;
import com.arvin.gifloader.loader.Loader;
import com.arvin.gifloader.request.GifRequest;
import com.arvin.gifloader.widget.GifView;

public abstract class AbsLoader
implements Loader {
    private static GifCache mCache = GifLoader.getInstance().getConfig().gifCache;

    @Override
    public final void loadGif(GifRequest request) {
        Movie movie = mCache.get(request);
        if (movie == null) {
            this.showLoading(request);
            byte[] bytes = this.onLoadGif(request);
            movie = Movie.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length);
            this.cacheBitmap(request, bytes);
            Log.e((String)"", (String)"-----e   null");
        } else {
            request.justCacheInMem = true;
            Log.e((String)"", (String)"----e not null");
        }
        this.deliveryToUIThread(request, movie);
    }

    protected abstract byte[] onLoadGif(GifRequest var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheBitmap(GifRequest request, byte[] value) {
        if (value != null && mCache != null) {
            GifCache gifCache = mCache;
            synchronized (gifCache) {
                mCache.put(request, value);
            }
        }
    }

    protected void showLoading(final GifRequest request) {
        final GifView gifView = request.getGifView();
        if (request.isGifViewTagValid() && this.hasLoadingPlaceholder(request.displayConfig)) {
            gifView.post(new Runnable(){

                @Override
                public void run() {
                    gifView.setImageResource(request.displayConfig.loadingResId);
                }
            });
        }
    }

    protected void deliveryToUIThread(final GifRequest request, final Movie movie) {
        GifView gifView = request.getGifView();
        if (gifView == null) {
            return;
        }
        gifView.post(new Runnable(){

            @Override
            public void run() {
                AbsLoader.this.updateImageView(request, movie);
            }
        });
    }

    private void updateImageView(GifRequest request, Movie result) {
        GifView gifView = request.getGifView();
        String uri = request.gifUrl;
        if (result != null && gifView.getTag().equals(uri)) {
            gifView.setMovie(result);
        }
        if (result == null && this.hasFaildPlaceholder(request.displayConfig)) {
            gifView.setImageResource(request.displayConfig.failedResId);
        }
        if (request.mGifLister != null) {
            request.mGifLister.onComplete(gifView, result, uri);
        }
    }

    private boolean hasLoadingPlaceholder(DisplayConfig displayConfig) {
        return displayConfig != null && displayConfig.loadingResId > 0;
    }

    private boolean hasFaildPlaceholder(DisplayConfig displayConfig) {
        return displayConfig != null && displayConfig.failedResId > 0;
    }
}

