/*
 * Decompiled with CFR 0.152.
 */
package com.arvin.gifloader.core;

import com.arvin.gifloader.core.RequestDispatcher;
import com.arvin.gifloader.request.GifRequest;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

public final class RequestQueue {
    private BlockingQueue<GifRequest> mRequestQueue = new PriorityBlockingQueue<GifRequest>();
    private AtomicInteger mSerialNumGenerator = new AtomicInteger(0);
    public static int DEFAULT_CORE_NUMS = Runtime.getRuntime().availableProcessors() + 1;
    private int mDispatcherNums = DEFAULT_CORE_NUMS;
    private RequestDispatcher[] mDispatchers = null;

    protected RequestQueue() {
        this(DEFAULT_CORE_NUMS);
    }

    protected RequestQueue(int coreNums) {
        this.mDispatcherNums = coreNums;
    }

    private final void startDispatchers() {
        this.mDispatchers = new RequestDispatcher[this.mDispatcherNums];
        for (int i = 0; i < this.mDispatcherNums; ++i) {
            this.mDispatchers[i] = new RequestDispatcher(this.mRequestQueue);
            this.mDispatchers[i].start();
        }
    }

    public void start() {
        this.stop();
        this.startDispatchers();
    }

    public void stop() {
        if (this.mDispatchers != null && this.mDispatchers.length > 0) {
            for (int i = 0; i < this.mDispatchers.length; ++i) {
                this.mDispatchers[i].interrupt();
            }
        }
    }

    public void addRequest(GifRequest request) {
        if (!this.mRequestQueue.contains(request)) {
            request.serialNum = this.generateSerialNumber();
            this.mRequestQueue.add(request);
        }
    }

    public void clear() {
        this.mRequestQueue.clear();
    }

    public BlockingQueue<GifRequest> getAllRequests() {
        return this.mRequestQueue;
    }

    private int generateSerialNumber() {
        return this.mSerialNumGenerator.incrementAndGet();
    }
}

