/*
 * Decompiled with CFR 0.152.
 */
package com.arvin.gifloader.core;

import android.util.Log;
import com.arvin.gifloader.loader.Loader;
import com.arvin.gifloader.loader.LoaderManager;
import com.arvin.gifloader.request.GifRequest;
import java.util.concurrent.BlockingQueue;

final class RequestDispatcher
extends Thread {
    private BlockingQueue<GifRequest> mRequestQueue;

    public RequestDispatcher(BlockingQueue<GifRequest> queue) {
        this.mRequestQueue = queue;
    }

    @Override
    public void run() {
        try {
            while (!this.isInterrupted()) {
                GifRequest request = this.mRequestQueue.take();
                if (request.isCancel) continue;
                String schema = this.parseSchema(request.gifUrl);
                Loader imageLoader = LoaderManager.getInstance().getLoader(schema);
                imageLoader.loadGif(request);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private String parseSchema(String uri) {
        if (uri.contains("://")) {
            return uri.split("://")[0];
        }
        Log.e((String)this.getName(), (String)("### wrong scheme, image uri is : " + uri));
        return "";
    }
}

