/*
 * Decompiled with CFR 0.152.
 */
package com.arvin.gifloader.core;

import android.graphics.Movie;
import android.util.Log;
import com.arvin.gifloader.cache.GifCache;
import com.arvin.gifloader.cache.MemoryCache;
import com.arvin.gifloader.config.DisplayConfig;
import com.arvin.gifloader.config.GifLoaderConfig;
import com.arvin.gifloader.core.RequestQueue;
import com.arvin.gifloader.policy.SerialPolicy;
import com.arvin.gifloader.request.GifRequest;
import com.arvin.gifloader.widget.GifView;

public final class GifLoader {
    private static volatile GifLoader sInstance;
    private volatile GifCache mGifCache = new MemoryCache();
    private RequestQueue mGifQueue;
    private GifLoaderConfig mConfig;

    private GifLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static GifLoader getInstance() {
        Log.e((String)"TAG", (String)"--------instance------------");
        if (sInstance == null) {
            Class<GifLoader> clazz = GifLoader.class;
            // MONITORENTER : com.arvin.gifloader.core.GifLoader.class
            if (sInstance == null) {
                sInstance = new GifLoader();
            }
            // MONITOREXIT : clazz
        }
        Log.e((String)"TAG", (String)("--------instance---return---------" + sInstance.hashCode()));
        return sInstance;
    }

    public GifLoaderConfig getConfig() {
        return this.mConfig;
    }

    public void init(GifLoaderConfig config) {
        this.mConfig = config;
        this.mGifCache = config.gifCache;
        this.checkConfig();
        this.mGifQueue = new RequestQueue(this.mConfig.threadCount);
        this.mGifQueue.start();
    }

    private void checkConfig() {
        if (this.mConfig == null) {
            throw new RuntimeException("The config of SimpleImageLoader is Null, please call the init(ImageLoaderConfig config) method to initialize");
        }
        if (this.mConfig.loadPolicy == null) {
            this.mConfig.loadPolicy = new SerialPolicy();
        }
        if (this.mGifCache == null) {
            this.mGifCache = new MemoryCache();
        }
    }

    public void displayGif(GifView gifView, String uri) {
        this.displayGif(gifView, uri, null, null);
    }

    public void displayGif(GifView gifView, String uri, DisplayConfig config) {
        this.displayGif(gifView, uri, config, null);
    }

    public void displayGif(GifView gifView, String uri, GifListener listener) {
        this.displayGif(gifView, uri, null, listener);
    }

    public void displayGif(GifView gifView, String uri, DisplayConfig config, GifListener listener) {
        GifRequest request = new GifRequest(gifView, config, uri, listener);
        request.displayConfig = request.displayConfig != null ? request.displayConfig : this.mConfig.displayConfig;
        this.mGifQueue.addRequest(request);
    }

    public void stop() {
        this.mGifQueue.stop();
    }

    public static interface GifListener {
        public void onComplete(GifView var1, Movie var2, String var3);
    }
}

