/*
 * Decompiled with CFR 0.152.
 */
package com.arvin.gifloader.config;

import com.arvin.gifloader.cache.GifCache;
import com.arvin.gifloader.cache.MemoryCache;
import com.arvin.gifloader.config.DisplayConfig;
import com.arvin.gifloader.policy.LoadPolicy;
import com.arvin.gifloader.policy.SerialPolicy;

public class GifLoaderConfig {
    public GifCache gifCache = new MemoryCache();
    public DisplayConfig displayConfig = new DisplayConfig();
    public LoadPolicy loadPolicy = new SerialPolicy();
    public int threadCount = Runtime.getRuntime().availableProcessors() + 1;

    public GifLoaderConfig setThreadCount(int count) {
        this.threadCount = Math.max(1, count);
        return this;
    }

    public GifLoaderConfig setCache(GifCache cache) {
        this.gifCache = cache;
        return this;
    }

    private GifLoaderConfig setLoadingPlaceholder(int resId) {
        this.displayConfig.loadingResId = resId;
        return this;
    }

    private GifLoaderConfig setNotFoundPlaceholder(int resId) {
        this.displayConfig.failedResId = resId;
        return this;
    }

    public GifLoaderConfig setLoadPolicy(LoadPolicy policy) {
        if (policy != null) {
            this.loadPolicy = policy;
        }
        return this;
    }
}

