/*
 * Decompiled with CFR 0.152.
 */
package com.arvin.gifloader.cache;

import android.graphics.Movie;
import com.arvin.gifloader.cache.GifCache;
import com.arvin.gifloader.request.GifRequest;
import java.lang.ref.Reference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class ReferenceCache
implements GifCache {
    private final Map<String, Reference<byte[]>> referenceMap = Collections.synchronizedMap(new HashMap());

    @Override
    public Movie get(GifRequest key) {
        Movie movie = null;
        Reference<byte[]> reference = this.referenceMap.get(key.gifUrlMd5);
        if (reference != null) {
            byte[] value = reference.get();
            movie = Movie.decodeByteArray((byte[])value, (int)0, (int)value.length);
        }
        return movie;
    }

    @Override
    public void put(GifRequest key, byte[] value) {
        this.referenceMap.put(key.gifUrlMd5, this.createReference(value));
    }

    @Override
    public void remove(GifRequest key) {
        this.referenceMap.remove(key.gifUrlMd5);
    }

    protected abstract Reference<byte[]> createReference(byte[] var1);
}

