/*
 * Decompiled with CFR 0.152.
 */
package com.arvin.gifloader.cache;

import android.graphics.Movie;
import android.util.LruCache;
import com.arvin.gifloader.cache.GifCache;
import com.arvin.gifloader.request.GifRequest;

public class MemoryCache
implements GifCache {
    private LruCache<String, byte[]> mMemoryCache;

    public MemoryCache() {
        int maxMemory = (int)Runtime.getRuntime().maxMemory() / 1024;
        int cacheSize = maxMemory / 4;
        this.mMemoryCache = new LruCache<String, byte[]>(cacheSize){

            protected int sizeOf(String key, byte[] value) {
                return value.length / 1024;
            }
        };
    }

    @Override
    public Movie get(GifRequest key) {
        byte[] value = (byte[])this.mMemoryCache.get((Object)key.gifUrlMd5);
        if (value == null) {
            return null;
        }
        return Movie.decodeByteArray((byte[])value, (int)0, (int)value.length);
    }

    @Override
    public void put(GifRequest key, byte[] value) {
        this.mMemoryCache.put((Object)key.gifUrlMd5, (Object)value);
    }

    @Override
    public void remove(GifRequest key) {
        this.mMemoryCache.remove((Object)key.gifUrlMd5);
    }
}

