/*
 * Decompiled with CFR 0.152.
 */
package com.arvin.gifloader.cache;

import android.content.Context;
import android.graphics.Movie;
import com.arvin.gifloader.cache.DiskCache;
import com.arvin.gifloader.cache.GifCache;
import com.arvin.gifloader.request.GifRequest;

public class DoubleCache
implements GifCache {
    private DiskCache mDiskCache;
    private GifCache mMemoryCache;

    public DoubleCache(Context context, GifCache mMemoryCache) {
        this.mMemoryCache = mMemoryCache;
        this.mDiskCache = DiskCache.getDiskCache(context.getApplicationContext());
    }

    @Override
    public Movie get(GifRequest key) {
        Movie movie = null;
        movie = this.mMemoryCache.get(key);
        if (movie == null) {
            movie = this.mDiskCache.get(key);
        }
        return movie;
    }

    @Override
    public void put(GifRequest key, byte[] value) {
        this.mMemoryCache.put(key, value);
        this.mDiskCache.put(key, value);
    }

    @Override
    public void remove(GifRequest key) {
        this.mMemoryCache.remove(key);
        this.mDiskCache.remove(key);
    }
}

