/*
 * Decompiled with CFR 0.152.
 */
package com.arvin.gifloader.cache;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Movie;
import android.os.Environment;
import android.util.Log;
import com.arvin.gifloader.cache.GifCache;
import com.arvin.gifloader.request.GifRequest;
import disklrucache.DiskLruCache;
import disklrucache.IOUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DiskCache
implements GifCache {
    private static final int MB = 0x100000;
    private static final String GIF_DISK_CACHE = "gif";
    private DiskLruCache mDiskLruCache;
    private static DiskCache mDiskCache;

    private DiskCache(Context context) {
        this.initDiskCache(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DiskCache getDiskCache(Context context) {
        if (mDiskCache != null) return mDiskCache;
        Class<DiskCache> clazz = DiskCache.class;
        synchronized (DiskCache.class) {
            if (mDiskCache != null) return mDiskCache;
            mDiskCache = new DiskCache(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mDiskCache;
        }
    }

    private void initDiskCache(Context context) {
        try {
            File cacheDir = this.getDiskCacheDir(context, GIF_DISK_CACHE);
            if (!cacheDir.exists()) {
                cacheDir.mkdirs();
            }
            this.mDiskLruCache = DiskLruCache.open(cacheDir, this.getAppVersion(context), 1, 0x3200000L);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private int getAppVersion(Context context) {
        try {
            PackageInfo info = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            return info.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return 1;
        }
    }

    public File getDiskCacheDir(Context context, String uniqueName) {
        String cachePath = "mounted".equals(Environment.getExternalStorageState()) ? context.getExternalCacheDir().getPath() : context.getCacheDir().getPath();
        Log.e((String)"tag", (String)("----cache----" + cachePath));
        return new File(cachePath + File.separator + uniqueName);
    }

    @Override
    public Movie get(GifRequest key) {
        Movie movie = null;
        try {
            DiskLruCache.Snapshot snapshot = this.mDiskLruCache.get(key.gifUrlMd5);
            if (snapshot != null) {
                movie = Movie.decodeStream((InputStream)snapshot.getInputStream(0));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return movie;
    }

    @Override
    public void put(GifRequest key, byte[] value) {
        DiskLruCache.Editor editor = null;
        try {
            editor = this.mDiskLruCache.edit(key.gifUrlMd5);
            if (editor != null) {
                OutputStream outputStream = editor.newOutputStream(0);
                if (this.writeGifToDisk(value, outputStream)) {
                    editor.commit();
                } else {
                    editor.abort();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void remove(GifRequest key) {
        try {
            this.mDiskLruCache.remove(key.gifUrlMd5);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeGifToDisk(byte[] value, OutputStream outputStream) {
        BufferedOutputStream bos = new BufferedOutputStream(outputStream, 8192);
        boolean result = true;
        try {
            outputStream.write(value);
            bos.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            result = false;
        }
        finally {
            IOUtil.closeQuietly(bos);
        }
        return result;
    }
}

