package com.arvin.gifloader.core;

import android.util.Log;

import com.arvin.gifloader.request.GifRequest;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * Created by arvin on 2016/9/2.
 */
public final class RequestQueue {
    /**
     */
    private BlockingQueue<GifRequest> mRequestQueue = new PriorityBlockingQueue<GifRequest>();
    /**
     */
    private AtomicInteger mSerialNumGenerator = new AtomicInteger(0);
    /**
     */
    public static int DEFAULT_CORE_NUMS = Runtime.getRuntime().availableProcessors() + 1;
    /**
     */
    private int mDispatcherNums = DEFAULT_CORE_NUMS;
    /**
     */
    private RequestDispatcher[] mDispatchers = null;

    /**
     *
     */
    protected RequestQueue() {
        this(DEFAULT_CORE_NUMS);
    }

    /**
     */
    protected RequestQueue(int coreNums) {
        mDispatcherNums = coreNums;
    }

    /**
     */
    private final void startDispatchers() {
        mDispatchers = new RequestDispatcher[mDispatcherNums];
        for (int i = 0; i < mDispatcherNums; i++) {
            //Log.e("", "### thread start " + i);
            mDispatchers[i] = new RequestDispatcher(mRequestQueue);
            mDispatchers[i].start();
        }
    }

    public void start() {
        stop();
        startDispatchers();
    }

    /**
     */
    public void stop() {
        if (mDispatchers != null && mDispatchers.length > 0) {
            for (int i = 0; i < mDispatchers.length; i++) {
                mDispatchers[i].interrupt();
            }
        }
    }

    /**
     *
     * @param request
     */
    public void addRequest(GifRequest request) {
        if (!mRequestQueue.contains(request)) {
            request.serialNum = this.generateSerialNumber();
            mRequestQueue.add(request);
        } else {
        }
    }

    public void clear() {
        mRequestQueue.clear();
    }

    public BlockingQueue<GifRequest> getAllRequests() {
        return mRequestQueue;
    }

    /**
     *
     */
    private int generateSerialNumber() {
        return mSerialNumGenerator.incrementAndGet();
    }
}
