package com.arthurivanets.adapster.databinding

/**
 *
 */
interface CanNotifyDataSetListeners<IT, DS : List<IT>> {

    /**
     *
     */
    fun notifyDataSetItemAdded(item : IT)

    /**
     *
     */
    fun notifyDataSetItemUpdated(item : IT)

    /**
     *
     */
    fun notifyDataSetItemReplaced(oldItem : IT, newItem : IT)

    /**
     *
     */
    fun notifyDataSetItemRemoved(item : IT)

    /**
     *
     */
    fun notifyDataSetSizeChanged(oldSize : Int, newSize : Int)

    /**
     *
     */
    fun notifyDataSetReplaced(items : DS)

    /**
     *
     */
    fun notifyDataSetCleared(items : DS)

}