package com.arthurivanets.adapster.databinding

import com.arthurivanets.adapster.model.markers.Trackable

/**
 *
 */
interface TrackableList<KT : Any, IT : Any> : MutableList<IT> {

    /**
     * @param items items to be added to the dataset
     * @param predicate predicate used to determine whether to apply the calculated dataset change associated with the specified item.
     */
    fun setItems(items : List<IT>, predicate : (IT) -> Boolean = { true })

    /**
     *
     */
    fun containsByKey(key : KT) : Boolean

    /**
     *
     */
    fun getTrackable(key : KT) : Trackable<KT>?

    /**
     *
     */
    fun <T> getTrackableAs(key : KT) : T?

}