/*
 * Decompiled with CFR 0.152.
 */
package com.arthenica.smartexception;

import com.arthenica.smartexception.PackageLoader;
import com.arthenica.smartexception.StackTraceElementSerializer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractExceptions {
    public static final int DEFAULT_MAX_DEPTH = 10;
    public static final boolean DEFAULT_IGNORE_ALL_CAUSES = false;
    public static final boolean DEFAULT_PRINT_PACKAGE_INFORMATION = false;
    public static final Set<String> rootPackageSet = Collections.synchronizedSet(new HashSet());
    public static final Set<String> groupPackageSet = Collections.synchronizedSet(new HashSet());
    public static final Set<String> ignorePackageSet = Collections.synchronizedSet(new HashSet());
    public static final Set<String> ignoreCausePackageSet = Collections.synchronizedSet(new HashSet());
    public static boolean ignoreAllCauses = false;
    public static StackTraceElementSerializer stackTraceElementSerializer;
    public static boolean printPackageInformation;

    public static void registerRootPackage(String packageString) {
        rootPackageSet.add(packageString);
    }

    public static void clearRootPackages() {
        rootPackageSet.clear();
    }

    public static void registerGroupPackage(String packageString) {
        groupPackageSet.add(packageString);
    }

    public static void clearGroupPackages() {
        groupPackageSet.clear();
    }

    public static StackTraceElementSerializer getStackTraceElementSerializer() {
        return stackTraceElementSerializer;
    }

    public static void setStackTraceElementSerializer(StackTraceElementSerializer stackTraceElementSerializer) {
        AbstractExceptions.stackTraceElementSerializer = stackTraceElementSerializer;
    }

    public static void registerIgnorePackage(String packageString, boolean ignoreCauseClasses) {
        ignorePackageSet.add(packageString);
        if (ignoreCauseClasses) {
            ignoreCausePackageSet.add(packageString);
        }
    }

    public static void clearIgnorePackages() {
        ignorePackageSet.clear();
        ignoreCausePackageSet.clear();
    }

    public static boolean getIgnoreAllCauses() {
        return ignoreAllCauses;
    }

    public static void setIgnoreAllCauses(boolean ignoreAllCauses) {
        AbstractExceptions.ignoreAllCauses = ignoreAllCauses;
    }

    public static boolean isPrintPackageInformation() {
        return printPackageInformation;
    }

    public static void setPrintPackageInformation(boolean printPackageInformation) {
        AbstractExceptions.printPackageInformation = printPackageInformation;
    }

    public static String getStackTraceString(Throwable throwable) {
        return AbstractExceptions.getStackTraceString(throwable, false, rootPackageSet, groupPackageSet, ignorePackageSet, 0, ignoreAllCauses, printPackageInformation);
    }

    public static String getStackTraceString(Throwable throwable, boolean ignoreAllCauses) {
        return AbstractExceptions.getStackTraceString(throwable, false, rootPackageSet, groupPackageSet, ignorePackageSet, 0, ignoreAllCauses, printPackageInformation);
    }

    public static String getStackTraceString(Throwable throwable, Set<String> rootPackageSet, Set<String> groupPackageSet, Set<String> ignorePackageSet) {
        return AbstractExceptions.getStackTraceString(throwable, false, rootPackageSet, groupPackageSet, ignorePackageSet, 0, ignoreAllCauses, printPackageInformation);
    }

    public static String getStackTraceString(Throwable throwable, Set<String> rootPackageSet, Set<String> groupPackageSet, Set<String> ignorePackageSet, boolean ignoreAllCauses) {
        return AbstractExceptions.getStackTraceString(throwable, false, rootPackageSet, groupPackageSet, ignorePackageSet, 0, ignoreAllCauses, printPackageInformation);
    }

    public static String getStackTraceString(Throwable throwable, Set<String> rootPackageSet, Set<String> groupPackageSet, Set<String> ignorePackageSet, boolean ignoreAllCauses, boolean printPackageInformation) {
        return AbstractExceptions.getStackTraceString(throwable, false, rootPackageSet, groupPackageSet, ignorePackageSet, 0, ignoreAllCauses, printPackageInformation);
    }

    public static String getStackTraceString(Throwable throwable, String rootPackage) {
        return AbstractExceptions.getStackTraceString(throwable, false, Collections.singleton(rootPackage), new HashSet<String>(), new HashSet<String>(), 0, ignoreAllCauses, printPackageInformation);
    }

    public static String getStackTraceString(Throwable throwable, String rootPackage, String groupPackage) {
        return AbstractExceptions.getStackTraceString(throwable, false, Collections.singleton(rootPackage), Collections.singleton(groupPackage), new HashSet<String>(), 0, ignoreAllCauses, printPackageInformation);
    }

    public static String getStackTraceString(Throwable throwable, int maxDepth) {
        return AbstractExceptions.getStackTraceString(throwable, false, new HashSet<String>(), new HashSet<String>(), new HashSet<String>(), maxDepth, ignoreAllCauses, printPackageInformation);
    }

    public static String getStackTraceString(Throwable throwable, int maxDepth, boolean ignoreAllCauses) {
        return AbstractExceptions.getStackTraceString(throwable, false, new HashSet<String>(), new HashSet<String>(), new HashSet<String>(), maxDepth, ignoreAllCauses, printPackageInformation);
    }

    public static String getStackTraceString(Throwable throwable, int maxDepth, boolean ignoreAllCauses, boolean printPackageInformation) {
        return AbstractExceptions.getStackTraceString(throwable, false, new HashSet<String>(), new HashSet<String>(), new HashSet<String>(), maxDepth, ignoreAllCauses, printPackageInformation);
    }

    public static String getStackTraceString(Throwable throwable, boolean isCause, Set<String> rootPackageSet, Set<String> groupPackageSet, Set<String> ignorePackageSet, int maxDepth, boolean ignoreAllCauses, boolean printPackageInformation) {
        StringBuilder builder = new StringBuilder();
        if (throwable == null) {
            return "";
        }
        String className = throwable.getClass().getName();
        StackTraceElement[] stackTraceElements = maxDepth > 0 ? AbstractExceptions.getStackTrace(throwable, maxDepth) : AbstractExceptions.getStackTrace(throwable, rootPackageSet, ignorePackageSet);
        String message = throwable.getLocalizedMessage();
        if (AbstractExceptions.isEmpty(message)) {
            message = throwable.getMessage();
        }
        if (isCause) {
            builder.append(System.lineSeparator());
            builder.append("Caused by: ");
            builder.append(className);
            if (!AbstractExceptions.isEmpty(message)) {
                builder.append(": ");
                builder.append(message);
            }
        } else {
            builder.append(System.lineSeparator());
            builder.append(className);
            if (!AbstractExceptions.isEmpty(message)) {
                builder.append(": ");
                builder.append(message);
            }
        }
        String currentGroupPackage = null;
        StackTraceElement firstStackTraceElementInTheGroup = null;
        int currentGroupCount = 0;
        for (StackTraceElement traceElement : stackTraceElements) {
            String traceElementClassName = traceElement.getClassName();
            String groupPackageMatch = AbstractExceptions.getContainingPackage(traceElementClassName, groupPackageSet);
            if (groupPackageMatch != null) {
                if (!groupPackageMatch.equals(currentGroupPackage)) {
                    AbstractExceptions.appendStackTraceGroupElement(builder, currentGroupPackage, currentGroupCount, firstStackTraceElementInTheGroup, printPackageInformation);
                    builder.append(System.lineSeparator());
                    builder.append("\tat ");
                    currentGroupPackage = groupPackageMatch;
                    firstStackTraceElementInTheGroup = traceElement;
                    currentGroupCount = 1;
                    continue;
                }
                ++currentGroupCount;
                continue;
            }
            currentGroupCount = AbstractExceptions.appendStackTraceGroupElement(builder, currentGroupPackage, currentGroupCount, firstStackTraceElementInTheGroup, printPackageInformation);
            builder.append(System.lineSeparator());
            builder.append("\tat ");
            if (stackTraceElementSerializer == null) {
                throw new IllegalArgumentException("Stack trace element serializer not initialized.");
            }
            builder.append(stackTraceElementSerializer.toString(traceElement, printPackageInformation));
            currentGroupPackage = null;
        }
        AbstractExceptions.appendStackTraceGroupElement(builder, currentGroupPackage, currentGroupCount, firstStackTraceElementInTheGroup, printPackageInformation);
        Throwable cause = throwable.getCause();
        if (cause != null && !AbstractExceptions.containsPackage(className, ignoreCausePackageSet) && !ignoreAllCauses) {
            builder.append(AbstractExceptions.getStackTraceString(cause, true, rootPackageSet, groupPackageSet, ignorePackageSet, maxDepth, ignoreAllCauses, printPackageInformation));
        }
        return builder.toString();
    }

    public static int appendStackTraceGroupElement(StringBuilder stringBuilder, String currentGroupPackage, int numberOfElementsInTheCurrentGroup, StackTraceElement firstStackTraceElementInTheGroup, boolean printPackageInformation) {
        if (numberOfElementsInTheCurrentGroup > 0) {
            if (stackTraceElementSerializer == null) {
                throw new IllegalArgumentException("Stack trace element serializer not initialized.");
            }
            if (numberOfElementsInTheCurrentGroup == 1) {
                stringBuilder.append(stackTraceElementSerializer.toString(firstStackTraceElementInTheGroup, printPackageInformation));
            } else {
                stringBuilder.append(String.format("%s%s ... %d more", stackTraceElementSerializer.getModuleName(firstStackTraceElementInTheGroup), currentGroupPackage, numberOfElementsInTheCurrentGroup - 1));
                if (printPackageInformation) {
                    stringBuilder.append(stackTraceElementSerializer.getPackageInformation(firstStackTraceElementInTheGroup));
                }
            }
        }
        return 0;
    }

    public static boolean containsPackage(String fullClassName, Set<String> packageSet) {
        return AbstractExceptions.getContainingPackage(fullClassName, packageSet) != null;
    }

    public static String getContainingPackage(String fullClassName, Set<String> packageSet) {
        for (String parentExceptionPackage : packageSet) {
            if (!fullClassName.startsWith(parentExceptionPackage)) continue;
            return parentExceptionPackage;
        }
        return null;
    }

    public static String getAllMessages(Throwable throwable) {
        StringBuilder messageBuilder = new StringBuilder();
        AbstractExceptions.getAllMessages(throwable, messageBuilder);
        return messageBuilder.toString();
    }

    public static void getAllMessages(Throwable throwable, StringBuilder messageBuilder) {
        if (throwable != null) {
            String message = throwable.getMessage();
            if (!AbstractExceptions.isEmpty(message)) {
                if (messageBuilder.length() != 0) {
                    messageBuilder.append(System.lineSeparator());
                    messageBuilder.append(" - Caused by: ");
                }
                messageBuilder.append(message);
            }
            AbstractExceptions.getAllMessages(throwable.getCause(), messageBuilder);
        }
    }

    public static StackTraceElement[] getStackTrace(Throwable throwable, int maxDepth) {
        ArrayList<StackTraceElement> list = new ArrayList<StackTraceElement>();
        if (throwable != null) {
            StackTraceElement[] stackTrace = throwable.getStackTrace();
            for (int i = 0; i < stackTrace.length && i < maxDepth; ++i) {
                list.add(stackTrace[i]);
            }
        }
        return list.toArray(new StackTraceElement[0]);
    }

    public static StackTraceElement[] getStackTrace(Throwable throwable, Set<String> rootPackageSet, Set<String> ignorePackageSet) {
        ArrayList list = new ArrayList();
        ArrayList<StackTraceElement> partialList = new ArrayList<StackTraceElement>();
        if (throwable != null) {
            for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
                String className = stackTraceElement.getClassName();
                if (AbstractExceptions.isEmpty(className)) continue;
                if (AbstractExceptions.containsPackage(className, rootPackageSet)) {
                    list.addAll(partialList);
                    list.add(stackTraceElement);
                    continue;
                }
                if (AbstractExceptions.containsPackage(className, ignorePackageSet)) continue;
                partialList.add(stackTraceElement);
            }
        }
        if (list.isEmpty()) {
            list.addAll(partialList);
        }
        return list.toArray(new StackTraceElement[0]);
    }

    public static boolean containsCause(Throwable throwable, Class<?> causeClass) {
        return AbstractExceptions.containsCause(throwable, causeClass, null);
    }

    public static boolean containsCause(Throwable throwable, Class<?> causeClass, String causeMessage) {
        return AbstractExceptions.searchCause(throwable, causeClass, causeMessage, 10) != null;
    }

    public static Throwable getCause(Throwable throwable) {
        return AbstractExceptions.getCause(throwable, 10);
    }

    public static Throwable getCause(Throwable throwable, int maxDepth) {
        if (throwable == null) {
            return null;
        }
        if (maxDepth <= 0) {
            return throwable;
        }
        Throwable cause = throwable.getCause();
        if (cause == null) {
            return throwable;
        }
        return AbstractExceptions.getCause(cause, maxDepth - 1);
    }

    public static Throwable searchCause(Throwable throwable, Class<?> causeClass) {
        return AbstractExceptions.searchCause(throwable, causeClass, null, 10);
    }

    public static Throwable searchCause(Throwable throwable, Class<?> causeClass, String causeMessage) {
        return AbstractExceptions.searchCause(throwable, causeClass, causeMessage, 10);
    }

    public static Throwable searchCause(Throwable throwable, Class<?> causeClass, String causeMessage, int maxDepth) {
        if (throwable == null) {
            return null;
        }
        if (AbstractExceptions.isEmpty(causeMessage) ? throwable.getClass().equals(causeClass) : throwable.getClass().equals(causeClass) && AbstractExceptions.getAllMessages(throwable).toLowerCase().contains(causeMessage.toLowerCase())) {
            return throwable;
        }
        if (maxDepth <= 0) {
            return null;
        }
        Throwable cause = throwable.getCause();
        if (cause == null) {
            return null;
        }
        return AbstractExceptions.searchCause(cause, causeClass, causeMessage, maxDepth - 1);
    }

    public static Throwable searchCause(Throwable throwable, Class<?> causeClass, int maxDepth) {
        if (throwable == null) {
            return null;
        }
        if (throwable.getClass().equals(causeClass)) {
            return throwable;
        }
        if (maxDepth <= 0) {
            return null;
        }
        Throwable cause = throwable.getCause();
        if (cause == null) {
            return null;
        }
        return AbstractExceptions.searchCause(cause, causeClass, maxDepth - 1);
    }

    public static boolean isEmpty(String value) {
        if (value == null) {
            return true;
        }
        return value.trim().length() == 0;
    }

    public static String packageName(String className) {
        if (className == null) {
            return "";
        }
        int index = className.lastIndexOf(".");
        if (index >= 0) {
            return className.substring(0, index);
        }
        return "";
    }

    public static String getVersion(PackageLoader packageLoader, Class<?> type, String packageName) {
        try {
            Package loadedPackage = type.getPackage();
            if (loadedPackage != null) {
                return loadedPackage.getImplementationVersion();
            }
            loadedPackage = packageLoader.getPackage(type.getClassLoader(), packageName);
            if (loadedPackage != null) {
                return loadedPackage.getImplementationVersion();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String libraryName(Class<?> type) {
        try {
            String resource;
            int index;
            URL resourceUrl;
            if (type != null && (resourceUrl = type.getClassLoader().getResource(type.getName().replace('.', '/') + ".class")) != null && (index = (resource = resourceUrl.toString()).lastIndexOf(33)) > 0) {
                if ((index = (resource = resource.substring(0, index)).lastIndexOf(47)) > 0) {
                    resource = resource.substring(index + 1);
                }
                if ((index = resource.lastIndexOf(92)) > 0) {
                    resource = resource.substring(index + 1);
                }
                return resource;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static {
        printPackageInformation = false;
    }
}

