/*
 * Decompiled with CFR 0.152.
 */
package com.arthenica.mobileffmpeg;

import android.util.Log;
import com.arthenica.mobileffmpeg.MediaInformation;
import com.arthenica.mobileffmpeg.StreamInformation;
import com.arthenica.mobileffmpeg.util.Pair;
import com.arthenica.mobileffmpeg.util.Trio;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class MediaInformationParser {
    public static SimpleDateFormat DURATION_FORMAT;
    public static Date REFERENCE_DURATION;

    public static MediaInformation from(String rawCommandOutput) {
        MediaInformation mediaInformation = new MediaInformation();
        if (rawCommandOutput != null) {
            String[] split = rawCommandOutput.split("\n");
            boolean metadata = false;
            boolean sidedata = false;
            StreamInformation lastCreatedStream = null;
            StringBuilder rawInformation = new StringBuilder();
            for (String outputLine : split) {
                Pair<String, String> pair;
                if (outputLine.startsWith("[")) {
                    metadata = false;
                    sidedata = false;
                    continue;
                }
                String trimmedLine = outputLine.trim();
                if (trimmedLine.startsWith("Input")) {
                    metadata = false;
                    sidedata = false;
                    lastCreatedStream = null;
                    pair = MediaInformationParser.parseInputBlock(trimmedLine);
                    mediaInformation.setFormat(pair.getFirst());
                    mediaInformation.setPath(pair.getSecond());
                } else if (trimmedLine.startsWith("Duration")) {
                    metadata = false;
                    sidedata = false;
                    lastCreatedStream = null;
                    Trio<Long, Long, Long> trio = MediaInformationParser.parseDurationBlock(trimmedLine);
                    mediaInformation.setDuration(trio.getFirst());
                    mediaInformation.setStartTime(trio.getSecond());
                    mediaInformation.setBitrate(trio.getThird());
                } else if (trimmedLine.toLowerCase(Locale.ENGLISH).startsWith("metadata")) {
                    sidedata = false;
                    metadata = true;
                } else if (trimmedLine.toLowerCase(Locale.ENGLISH).startsWith("side data")) {
                    metadata = false;
                    sidedata = true;
                } else {
                    if (trimmedLine.startsWith("Stream mapping") || trimmedLine.startsWith("Press [q] to stop") || trimmedLine.startsWith("Output")) break;
                    if (trimmedLine.startsWith("Stream")) {
                        metadata = false;
                        sidedata = false;
                        lastCreatedStream = MediaInformationParser.parseStreamBlock(trimmedLine);
                        mediaInformation.addStream(lastCreatedStream);
                    } else if (metadata) {
                        pair = MediaInformationParser.parseMetadataBlock(trimmedLine);
                        if (pair.getFirst() != null && pair.getSecond() != null) {
                            if (lastCreatedStream != null) {
                                lastCreatedStream.addMetadata(pair.getFirst(), pair.getSecond());
                            } else {
                                mediaInformation.addMetadata(pair.getFirst(), pair.getSecond());
                            }
                        }
                    } else if (sidedata && (pair = MediaInformationParser.parseMetadataBlock(trimmedLine)).getFirst() != null && pair.getSecond() != null && lastCreatedStream != null) {
                        lastCreatedStream.addSidedata(pair.getFirst(), pair.getSecond());
                    }
                }
                rawInformation.append(outputLine);
                rawInformation.append("\n");
            }
            mediaInformation.setRawInformation(rawInformation.toString());
        }
        return mediaInformation;
    }

    static Pair<String, String> parseInputBlock(String input) {
        String format = MediaInformationParser.substring(input, ",", ", from", Collections.emptyList());
        String path = MediaInformationParser.substring(input, "'", "'", Collections.emptyList());
        return new Pair<String, String>(format, path);
    }

    static Trio<Long, Long, Long> parseDurationBlock(String line) {
        Long duration = MediaInformationParser.parseDuration(MediaInformationParser.substring(line, "Duration:", ",", Collections.singletonList("uration:")));
        Long start = MediaInformationParser.parseStartTime(MediaInformationParser.substring(line, "start:", ",", Collections.singletonList("tart:")));
        Long bitrate = MediaInformationParser.toLongObject(MediaInformationParser.substring(line, "bitrate:", Arrays.asList("itrate:", "kb/s")));
        return new Trio<Long, Long, Long>(duration, start, bitrate);
    }

    static Pair<String, String> parseMetadataBlock(String metadata) {
        int index;
        String key = null;
        String value = null;
        if (metadata != null && (index = metadata.indexOf(58)) > -1) {
            key = metadata.substring(0, index).trim();
            value = metadata.substring(index + 1).trim();
        }
        return new Pair<Object, Object>(key, value);
    }

    static StreamInformation parseStreamBlock(String input) {
        StreamInformation streamInformation = new StreamInformation();
        if (input != null) {
            streamInformation.setIndex(MediaInformationParser.parseStreamIndex(input));
            int typeBlockStartIndex = MediaInformationParser.index(input, ":", 0, 2);
            if (typeBlockStartIndex > -1 && typeBlockStartIndex < input.length()) {
                String[] parts = input.substring(typeBlockStartIndex + 1).split(",");
                String typePart = MediaInformationParser.safeGet(parts, 0);
                String type = MediaInformationParser.parseStreamType(typePart);
                streamInformation.setType(type);
                streamInformation.setCodec(MediaInformationParser.parseStreamCodec(typePart));
                streamInformation.setFullCodec(MediaInformationParser.parseStreamFullCodec(typePart));
                String part2 = MediaInformationParser.safeGet(parts, 1);
                String part3 = MediaInformationParser.safeGet(parts, 2);
                String part4 = MediaInformationParser.safeGet(parts, 3);
                String part5 = MediaInformationParser.safeGet(parts, 4);
                if ("video".equals(type)) {
                    String videoDimensionPart;
                    int lastUsedPart = 1;
                    if (part2 != null) {
                        String newPart;
                        int pStart = MediaInformationParser.count(part2, "(");
                        int pEnd = MediaInformationParser.count(part2, ")");
                        while (pStart != pEnd && (newPart = MediaInformationParser.safeGet(parts, ++lastUsedPart)) != null) {
                            part2 = String.format("%s,%s", part2, newPart);
                            pStart = MediaInformationParser.count(part2, "(");
                            pEnd = MediaInformationParser.count(part2, ")");
                        }
                        streamInformation.setFullFormat(part2.toLowerCase(Locale.getDefault()).trim());
                        streamInformation.setFormat(part2.replaceAll("\\(.*\\)", "").toLowerCase(Locale.getDefault()).trim());
                    }
                    if ((videoDimensionPart = MediaInformationParser.safeGet(parts, ++lastUsedPart)) != null) {
                        String videoLayout = videoDimensionPart.toLowerCase(Locale.getDefault()).trim();
                        Pair<Long, Long> dimensions = MediaInformationParser.parseVideoDimensions(videoLayout);
                        streamInformation.setWidth(dimensions.getFirst());
                        streamInformation.setHeight(dimensions.getSecond());
                        streamInformation.setSampleAspectRatio(MediaInformationParser.parseVideoStreamSampleAspectRatio(videoLayout));
                        streamInformation.setDisplayAspectRatio(MediaInformationParser.parseVideoStreamDisplayAspectRatio(videoLayout));
                    }
                    for (int i = lastUsedPart + 1; i < parts.length; ++i) {
                        String part = parts[i].replaceAll("\\(.*\\)", "").toLowerCase(Locale.getDefault());
                        if (part.contains("kb/s")) {
                            streamInformation.setBitrate(MediaInformationParser.toLongObject(part.replaceAll("kb/s", "").trim()));
                            continue;
                        }
                        if (part.contains("fps")) {
                            streamInformation.setAverageFrameRate(part.replaceAll("fps", "").trim());
                            continue;
                        }
                        if (part.contains("tbr")) {
                            streamInformation.setRealFrameRate(part.replaceAll("tbr", "").trim());
                            continue;
                        }
                        if (part.contains("tbn")) {
                            streamInformation.setTimeBase(part.replaceAll("tbn", "").trim());
                            continue;
                        }
                        if (!part.contains("tbc")) continue;
                        streamInformation.setCodecTimeBase(part.replaceAll("tbc", "").trim());
                    }
                } else if ("audio".equals(type)) {
                    if (part2 != null) {
                        streamInformation.setSampleRate(MediaInformationParser.parseAudioStreamSampleRate(part2));
                    }
                    if (part3 != null) {
                        streamInformation.setChannelLayout(part3.toLowerCase(Locale.getDefault()).trim());
                    }
                    if (part4 != null) {
                        streamInformation.setSampleFormat(part4.toLowerCase(Locale.getDefault()).trim());
                    }
                    if (part5 != null) {
                        streamInformation.setBitrate(MediaInformationParser.toLongObject(part5.toLowerCase(Locale.getDefault()).replaceAll("\\(.*\\)", "").replaceAll("kb/s", "").trim()));
                    }
                } else if ("data".equals(type) && part2 != null) {
                    streamInformation.setBitrate(MediaInformationParser.toLongObject(part2.toLowerCase(Locale.getDefault()).replaceAll("\\(.*\\)", "").replaceAll("kb/s", "").trim()));
                }
            }
        }
        return streamInformation;
    }

    static Pair<Long, Long> parseVideoDimensions(String input) {
        Long width = null;
        Long height = null;
        if (input != null) {
            String[] dimensions = input.toLowerCase(Locale.getDefault()).replaceAll("\\[.*\\]", "").trim().split("x");
            width = MediaInformationParser.toLongObject(MediaInformationParser.safeGet(dimensions, 0));
            height = MediaInformationParser.toLongObject(MediaInformationParser.safeGet(dimensions, 1));
        }
        return new Pair<Object, Object>(width, height);
    }

    static String parseVideoStreamSampleAspectRatio(String input) {
        if (input != null) {
            String[] parts = input.replaceAll("\\[", "").replaceAll("\\]", "").split(" ");
            for (int i = 0; i < parts.length; ++i) {
                if (!parts[i].toLowerCase(Locale.getDefault()).equals("sar")) continue;
                return MediaInformationParser.safeGet(parts, i + 1);
            }
        }
        return null;
    }

    static String parseVideoStreamDisplayAspectRatio(String input) {
        if (input != null) {
            String[] parts = input.replaceAll("\\[", "").replaceAll("\\]", "").split(" ");
            for (int i = 0; i < parts.length; ++i) {
                if (!parts[i].toLowerCase(Locale.getDefault()).equals("dar")) continue;
                return MediaInformationParser.safeGet(parts, i + 1);
            }
        }
        return null;
    }

    static Long parseAudioStreamSampleRate(String input) {
        if (input != null) {
            boolean khz = false;
            boolean mhz = false;
            String lowerCase = input.toLowerCase(Locale.getDefault());
            if (lowerCase.contains("khz")) {
                khz = true;
            }
            if (lowerCase.contains("mhz")) {
                mhz = true;
            }
            String sampleRate = lowerCase.replaceAll("khz", "").replaceAll("mhz", "").replaceAll("hz", "").trim();
            if (khz) {
                return 1000L * MediaInformationParser.toLong(sampleRate);
            }
            if (mhz) {
                return 1000000L * MediaInformationParser.toLong(sampleRate);
            }
            return MediaInformationParser.toLong(sampleRate);
        }
        return null;
    }

    static String parseStreamType(String input) {
        if (input != null) {
            if (input.toLowerCase(Locale.getDefault()).contains("audio:")) {
                return "audio";
            }
            if (input.toLowerCase(Locale.getDefault()).contains("video:")) {
                return "video";
            }
            if (input.toLowerCase(Locale.getDefault()).contains("data:")) {
                return "data";
            }
        }
        return null;
    }

    static String parseStreamCodec(String input) {
        if (input != null) {
            return input.toLowerCase(Locale.getDefault()).replaceAll("\\(.*\\)", "").replaceAll("video:", "").replaceAll("audio:", "").replaceAll("data:", "").trim();
        }
        return null;
    }

    static String parseStreamFullCodec(String input) {
        if (input != null) {
            return input.toLowerCase(Locale.getDefault()).replaceAll("video:", "").replaceAll("audio:", "").replaceAll("data:", "").trim();
        }
        return null;
    }

    static Long parseStreamIndex(String input) {
        String substring = MediaInformationParser.substring(input, "Stream #0:", ":", Collections.singletonList("tream #0"));
        if (substring != null) {
            return MediaInformationParser.toLongObject(substring.replace(":", "").replaceAll("\\(.*\\)", ""));
        }
        return null;
    }

    static Long parseDuration(String duration) {
        if (duration == null || duration.equals("N/A")) {
            return null;
        }
        try {
            Date calculated = DURATION_FORMAT.parse(duration);
            long secondsPartInMilliseconds = calculated.getTime() - REFERENCE_DURATION.getTime();
            int index = duration.indexOf(46);
            if (index > -1) {
                Long centiSeconds = MediaInformationParser.toLong(duration.substring(index + 1));
                secondsPartInMilliseconds += 10L * centiSeconds;
            }
            return secondsPartInMilliseconds;
        }
        catch (ParseException e) {
            Log.d((String)"mobile-ffmpeg", (String)String.format("Parsing duration: %s failed.", duration), (Throwable)e);
            return null;
        }
    }

    static Long parseStartTime(String startTime) {
        if (startTime == null || startTime.equals("N/A")) {
            return null;
        }
        try {
            BigDecimal bigDecimal = new BigDecimal(startTime);
            bigDecimal = bigDecimal.setScale(3, 2).multiply(new BigDecimal(1000));
            return bigDecimal.longValue();
        }
        catch (NumberFormatException e) {
            Log.d((String)"mobile-ffmpeg", (String)String.format("Parsing startTime: %s failed.", startTime), (Throwable)e);
            return null;
        }
    }

    public static String substring(String string, String start, String end, List<String> ignoredTokens) {
        int formatEnd;
        int formatStart;
        String extractedSubstring = null;
        if (string != null && (formatStart = string.indexOf(start)) > -1 && (formatEnd = string.indexOf(end, formatStart + start.length())) > -1) {
            extractedSubstring = string.substring(formatStart + start.length(), formatEnd);
        }
        if (ignoredTokens != null && extractedSubstring != null) {
            for (String token : ignoredTokens) {
                extractedSubstring = extractedSubstring.replaceAll(token, "");
            }
        }
        return extractedSubstring == null ? null : extractedSubstring.trim();
    }

    public static String substring(String string, String start, List<String> ignoredTokens) {
        int formatStart;
        String extractedSubstring = null;
        if (string != null && (formatStart = string.indexOf(start)) > -1) {
            extractedSubstring = string.substring(formatStart + 1);
        }
        if (ignoredTokens != null && extractedSubstring != null) {
            for (String token : ignoredTokens) {
                extractedSubstring = extractedSubstring.replaceAll(token, "");
            }
        }
        return extractedSubstring == null ? null : extractedSubstring.trim();
    }

    public static int index(String string, String substring, int startIndex, int n) {
        for (int count = 1; count <= n; ++count) {
            startIndex = string.indexOf(substring, startIndex + substring.length());
        }
        return startIndex;
    }

    public static int count(String string, String substring) {
        int count = 0;
        int index = 0;
        do {
            if ((index = string.indexOf(substring, index)) < 0) continue;
            ++count;
            index += substring.length();
        } while (index >= 0);
        return count;
    }

    private static <K> K safeGet(K[] array, int index) {
        if (array == null) {
            return null;
        }
        try {
            int size = array.length;
            if (size > index) {
                return array[index];
            }
            return null;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    private static long toLong(String value) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    static Long toLongObject(String value) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    static {
        try {
            DURATION_FORMAT = new SimpleDateFormat("kk:mm:ss", Locale.getDefault());
            REFERENCE_DURATION = DURATION_FORMAT.parse("00:00:00");
        }
        catch (ParseException e) {
            Log.i((String)"mobile-ffmpeg", (String)"Preparing duration reference failed.", (Throwable)e);
            DURATION_FORMAT = null;
            REFERENCE_DURATION = null;
        }
    }
}

