/*
 * Decompiled with CFR 0.152.
 */
package com.arthenica.mobileffmpeg;

import android.util.Log;
import com.arthenica.mobileffmpeg.AbiDetect;
import com.arthenica.mobileffmpeg.Config;
import com.arthenica.mobileffmpeg.MediaInformation;
import com.arthenica.mobileffmpeg.MediaInformationParser;
import java.util.ArrayList;
import java.util.Arrays;

public class FFmpeg {
    public static final int RETURN_CODE_SUCCESS = 0;
    public static final int RETURN_CODE_CANCEL = 255;
    private static int lastReturnCode = 0;
    private static StringBuffer lastCommandOutput = new StringBuffer();

    private FFmpeg() {
    }

    static void appendCommandOutput(String output) {
        lastCommandOutput.append(output);
    }

    public static String getFFmpegVersion() {
        return Config.getNativeFFmpegVersion();
    }

    public static String getVersion() {
        if (AbiDetect.isNativeLTSBuild()) {
            return String.format("%s-lts", Config.getNativeVersion());
        }
        return Config.getNativeVersion();
    }

    public static int execute(String[] arguments) {
        lastCommandOutput = new StringBuffer();
        lastReturnCode = Config.nativeExecute(arguments);
        return lastReturnCode;
    }

    public static int execute(String command, String delimiter) {
        String[] stringArray;
        if (command == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        } else {
            stringArray = command.split(delimiter == null ? " " : delimiter);
        }
        return FFmpeg.execute(stringArray);
    }

    public static int execute(String command) {
        return FFmpeg.execute(command, " ");
    }

    public static void cancel() {
        Config.nativeCancel();
    }

    public static int getLastReturnCode() {
        return lastReturnCode;
    }

    public static String getLastCommandOutput() {
        return lastCommandOutput.toString();
    }

    public static MediaInformation getMediaInformation(String path) {
        return FFmpeg.getMediaInformation(path, 10000L);
    }

    public static MediaInformation getMediaInformation(String path, Long timeout) {
        int rc = Config.systemExecute(new String[]{"-v", "info", "-hide_banner", "-i", path}, new ArrayList<String>(Arrays.asList("Press [q] to stop, [?] for help", "No such file or directory", "Input/output error", "Conversion failed", "HTTP error")), "At least one output file must be specified", timeout);
        if (rc == 0) {
            return MediaInformationParser.from(Config.getSystemCommandOutput());
        }
        Log.i((String)"mobile-ffmpeg", (String)Config.getSystemCommandOutput());
        return null;
    }

    public static boolean isLTSBuild() {
        return AbiDetect.isNativeLTSBuild();
    }

    public static String getBuildDate() {
        return Config.getNativeBuildDate();
    }

    static {
        AbiDetect.class.getName();
        Config.class.getName();
    }
}

