/*
 * Decompiled with CFR 0.152.
 */
package com.artem.bakuta.logger;

import android.arch.persistence.room.Room;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import com.artem.bakuta.logger.AppDatabase;
import com.artem.bakuta.logger.Log;
import com.artem.bakuta.logger.service.LoggerService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class LogConfig {
    public boolean LOGGER_ENABLE;
    public String DATABASE_NAME = "QaLogger";
    public String DATE_FORMAT = "HH:mm:ss dd.MM.YYYY";
    public static final int DB_VERSION = 4;
    private static LogConfig instance;
    private Context context;
    private AppDatabase db;
    private ExecutorService backgroundExecutor;

    public static synchronized LogConfig getInstance() {
        if (instance == null) {
            instance = new LogConfig();
        }
        return instance;
    }

    public void init(Context context) {
        this.context = context;
        this.db = (AppDatabase)Room.databaseBuilder((Context)context, AppDatabase.class, (String)this.DATABASE_NAME).fallbackToDestructiveMigration().build();
        this.backgroundExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(@NonNull Runnable runnable) {
                Thread thread = new Thread(runnable, "Background executor service");
                thread.setPriority(1);
                thread.setDaemon(true);
                return thread;
            }
        });
    }

    public void runInBackground(final Runnable runnable) {
        this.backgroundExecutor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    runnable.run();
                }
                catch (Exception e) {
                    Log.e(Thread.currentThread().getName(), "Background work exception.", e);
                }
            }
        });
    }

    public void enableLogger() {
        this.LOGGER_ENABLE = true;
        this.context.startService(new Intent(this.context, LoggerService.class));
    }

    public void disableLogger() {
        this.LOGGER_ENABLE = false;
        this.context.stopService(new Intent(this.context, LoggerService.class));
    }

    public void clearDatabase() {
        this.db.logEntityDao().deleteAllTable();
    }

    public AppDatabase getDatabase() {
        return this.db;
    }
}

