/*
 * Decompiled with CFR 0.152.
 */
package com.artem.bakuta.logger.dao;

import android.arch.lifecycle.ComputableLiveData;
import android.arch.lifecycle.LiveData;
import android.arch.persistence.db.SupportSQLiteQuery;
import android.arch.persistence.db.SupportSQLiteStatement;
import android.arch.persistence.room.EntityDeletionOrUpdateAdapter;
import android.arch.persistence.room.EntityInsertionAdapter;
import android.arch.persistence.room.InvalidationTracker;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.RoomSQLiteQuery;
import android.arch.persistence.room.SharedSQLiteStatement;
import android.database.Cursor;
import android.support.annotation.NonNull;
import com.artem.bakuta.logger.dao.LogEntityDao;
import com.artem.bakuta.logger.model.LogEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class LogEntityDao_Impl
implements LogEntityDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfLogEntity;
    private final EntityDeletionOrUpdateAdapter __deletionAdapterOfLogEntity;
    private final EntityDeletionOrUpdateAdapter __updateAdapterOfLogEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAllTable;

    public LogEntityDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfLogEntity = new EntityInsertionAdapter<LogEntity>(__db){

            public String createQuery() {
                return "INSERT OR ABORT INTO `LogEntity`(`id`,`tag`,`message`,`throwableError`,`date`,`type`) VALUES (nullif(?, 0),?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, LogEntity value) {
                stmt.bindLong(1, value.id);
                if (value.tag == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.tag);
                }
                if (value.message == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.message);
                }
                if (value.throwableError == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.throwableError);
                }
                if (value.date == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.date);
                }
                stmt.bindLong(6, (long)value.type);
            }
        };
        this.__deletionAdapterOfLogEntity = new EntityDeletionOrUpdateAdapter<LogEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `LogEntity` WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, LogEntity value) {
                stmt.bindLong(1, value.id);
            }
        };
        this.__updateAdapterOfLogEntity = new EntityDeletionOrUpdateAdapter<LogEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `LogEntity` SET `id` = ?,`tag` = ?,`message` = ?,`throwableError` = ?,`date` = ?,`type` = ? WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, LogEntity value) {
                stmt.bindLong(1, value.id);
                if (value.tag == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.tag);
                }
                if (value.message == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.message);
                }
                if (value.throwableError == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.throwableError);
                }
                if (value.date == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.date);
                }
                stmt.bindLong(6, (long)value.type);
                stmt.bindLong(7, value.id);
            }
        };
        this.__preparedStmtOfDeleteAllTable = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM logentity";
                return "DELETE FROM logentity";
            }
        };
    }

    @Override
    public void insert(LogEntity employee) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfLogEntity.insert((Object)employee);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(LogEntity employee) {
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfLogEntity.handle((Object)employee);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(LogEntity employee) {
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfLogEntity.handle((Object)employee);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAllTable() {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAllTable.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAllTable.release(_stmt);
        }
    }

    @Override
    public LiveData<List<LogEntity>> getAll() {
        String _sql = "SELECT * FROM logentity";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM logentity", (int)0);
        return new ComputableLiveData<List<LogEntity>>(){
            private InvalidationTracker.Observer _observer;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected List<LogEntity> compute() {
                if (this._observer == null) {
                    this._observer = new InvalidationTracker.Observer("logentity", new String[0]){

                        public void onInvalidated(@NonNull Set<String> tables) {
                            this.invalidate();
                        }
                    };
                    LogEntityDao_Impl.this.__db.getInvalidationTracker().addWeakObserver(this._observer);
                }
                try (Cursor _cursor = LogEntityDao_Impl.this.__db.query((SupportSQLiteQuery)_statement);){
                    int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
                    int _cursorIndexOfTag = _cursor.getColumnIndexOrThrow("tag");
                    int _cursorIndexOfMessage = _cursor.getColumnIndexOrThrow("message");
                    int _cursorIndexOfThrowableError = _cursor.getColumnIndexOrThrow("throwableError");
                    int _cursorIndexOfDate = _cursor.getColumnIndexOrThrow("date");
                    int _cursorIndexOfType = _cursor.getColumnIndexOrThrow("type");
                    ArrayList<LogEntity> _result = new ArrayList<LogEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        LogEntity _item = new LogEntity();
                        _item.id = _cursor.getLong(_cursorIndexOfId);
                        _item.tag = _cursor.getString(_cursorIndexOfTag);
                        _item.message = _cursor.getString(_cursorIndexOfMessage);
                        _item.throwableError = _cursor.getString(_cursorIndexOfThrowableError);
                        _item.date = _cursor.getString(_cursorIndexOfDate);
                        _item.type = _cursor.getInt(_cursorIndexOfType);
                        _result.add(_item);
                    }
                    ArrayList<LogEntity> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        }.getLiveData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LogEntity getById(long id2) {
        String _sql = "SELECT * FROM logentity WHERE id = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM logentity WHERE id = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, id2);
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            LogEntity _result;
            int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
            int _cursorIndexOfTag = _cursor.getColumnIndexOrThrow("tag");
            int _cursorIndexOfMessage = _cursor.getColumnIndexOrThrow("message");
            int _cursorIndexOfThrowableError = _cursor.getColumnIndexOrThrow("throwableError");
            int _cursorIndexOfDate = _cursor.getColumnIndexOrThrow("date");
            int _cursorIndexOfType = _cursor.getColumnIndexOrThrow("type");
            if (_cursor.moveToFirst()) {
                _result = new LogEntity();
                _result.id = _cursor.getLong(_cursorIndexOfId);
                _result.tag = _cursor.getString(_cursorIndexOfTag);
                _result.message = _cursor.getString(_cursorIndexOfMessage);
                _result.throwableError = _cursor.getString(_cursorIndexOfThrowableError);
                _result.date = _cursor.getString(_cursorIndexOfDate);
                _result.type = _cursor.getInt(_cursorIndexOfType);
            } else {
                _result = null;
            }
            LogEntity logEntity = _result;
            return logEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public LiveData<List<LogEntity>> getByTag(String tag) {
        String _sql = "SELECT * FROM logentity WHERE tag = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM logentity WHERE tag = ?", (int)1);
        int _argIndex = 1;
        if (tag == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, tag);
        }
        return new ComputableLiveData<List<LogEntity>>(){
            private InvalidationTracker.Observer _observer;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected List<LogEntity> compute() {
                if (this._observer == null) {
                    this._observer = new InvalidationTracker.Observer("logentity", new String[0]){

                        public void onInvalidated(@NonNull Set<String> tables) {
                            this.invalidate();
                        }
                    };
                    LogEntityDao_Impl.this.__db.getInvalidationTracker().addWeakObserver(this._observer);
                }
                try (Cursor _cursor = LogEntityDao_Impl.this.__db.query((SupportSQLiteQuery)_statement);){
                    int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
                    int _cursorIndexOfTag = _cursor.getColumnIndexOrThrow("tag");
                    int _cursorIndexOfMessage = _cursor.getColumnIndexOrThrow("message");
                    int _cursorIndexOfThrowableError = _cursor.getColumnIndexOrThrow("throwableError");
                    int _cursorIndexOfDate = _cursor.getColumnIndexOrThrow("date");
                    int _cursorIndexOfType = _cursor.getColumnIndexOrThrow("type");
                    ArrayList<LogEntity> _result = new ArrayList<LogEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        LogEntity _item = new LogEntity();
                        _item.id = _cursor.getLong(_cursorIndexOfId);
                        _item.tag = _cursor.getString(_cursorIndexOfTag);
                        _item.message = _cursor.getString(_cursorIndexOfMessage);
                        _item.throwableError = _cursor.getString(_cursorIndexOfThrowableError);
                        _item.date = _cursor.getString(_cursorIndexOfDate);
                        _item.type = _cursor.getInt(_cursorIndexOfType);
                        _result.add(_item);
                    }
                    ArrayList<LogEntity> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        }.getLiveData();
    }

    @Override
    public LiveData<List<String>> getAllTags() {
        String _sql = "SELECT DISTINCT tag FROM logentity";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT DISTINCT tag FROM logentity", (int)0);
        return new ComputableLiveData<List<String>>(){
            private InvalidationTracker.Observer _observer;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected List<String> compute() {
                if (this._observer == null) {
                    this._observer = new InvalidationTracker.Observer("logentity", new String[0]){

                        public void onInvalidated(@NonNull Set<String> tables) {
                            this.invalidate();
                        }
                    };
                    LogEntityDao_Impl.this.__db.getInvalidationTracker().addWeakObserver(this._observer);
                }
                try (Cursor _cursor = LogEntityDao_Impl.this.__db.query((SupportSQLiteQuery)_statement);){
                    ArrayList<String> _result = new ArrayList<String>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _item = _cursor.getString(0);
                        _result.add(_item);
                    }
                    ArrayList<String> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        }.getLiveData();
    }
}

