/*
 * Decompiled with CFR 0.152.
 */
package com.artem.bakuta.logger.activity;

import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.LiveData;
import android.arch.lifecycle.Observer;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.design.widget.FloatingActionButton;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.Spinner;
import android.widget.TextView;
import com.artem.bakuta.logger.LogConfig;
import com.artem.bakuta.logger.R;
import com.artem.bakuta.logger.model.LogEntity;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class LoggerActivity
extends AppCompatActivity {
    private String DEFAULT;
    private RecyclerView recycler;
    private Adapter adapter;
    private LinearLayoutManager layout;
    private FloatingActionButton mFloatingActionButton;
    private Spinner spinner;
    private ArrayAdapter<String> stringArrayAdapter;
    private List<String> spinnerList;
    private String CURRENT_FILTER_TAG;
    private LiveData<List<LogEntity>> byTagLiveData;
    private Button btn_send;
    final Observer<List<LogEntity>> nameObserver;
    final Observer<List<String>> tagsObserver;

    public LoggerActivity() {
        this.CURRENT_FILTER_TAG = this.DEFAULT = "DEFAULT_ALL_FILTERS";
        this.nameObserver = new Observer<List<LogEntity>>(){

            public void onChanged(@Nullable List<LogEntity> newName) {
                if (LoggerActivity.this.layout.findLastCompletelyVisibleItemPosition() == LoggerActivity.this.adapter.getItemCount() - 1) {
                    LoggerActivity.this.adapter.setData(newName);
                    LoggerActivity.this.adapter.notifyDataSetChanged();
                    LoggerActivity.this.recycler.scrollToPosition(LoggerActivity.this.adapter.getItemCount() - 1);
                } else {
                    LoggerActivity.this.adapter.setData(newName);
                    LoggerActivity.this.adapter.notifyDataSetChanged();
                }
            }
        };
        this.tagsObserver = new Observer<List<String>>(){

            public void onChanged(@Nullable List<String> newName) {
                LoggerActivity.this.stringArrayAdapter.clear();
                LoggerActivity.this.stringArrayAdapter.add((Object)LoggerActivity.this.DEFAULT);
                LoggerActivity.this.stringArrayAdapter.addAll(newName);
            }
        };
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_logger);
        this.recycler = (RecyclerView)this.findViewById(R.id.recycler);
        this.btn_send = (Button)this.findViewById(R.id.btn_send);
        this.mFloatingActionButton = (FloatingActionButton)this.findViewById(R.id.floating_action_button);
        this.spinner = (Spinner)this.findViewById(R.id.spinner);
        this.spinnerList = new ArrayList<String>();
        this.stringArrayAdapter = new ArrayAdapter((Context)this, R.layout.spinner_drop_down, R.id.tv_tag, this.spinnerList);
        this.stringArrayAdapter.setDropDownViewResource(R.layout.spinner_drop_down);
        this.spinner.setAdapter(this.stringArrayAdapter);
        final LiveData<List<LogEntity>> allTagsLiveData = LogConfig.getInstance().getDatabase().logEntityDao().getAll();
        allTagsLiveData.observe((LifecycleOwner)this, this.nameObserver);
        LiveData<List<String>> justTagsLiveData = LogConfig.getInstance().getDatabase().logEntityDao().getAllTags();
        justTagsLiveData.observe((LifecycleOwner)this, this.tagsObserver);
        this.adapter = new Adapter();
        this.recycler.setAdapter((RecyclerView.Adapter)this.adapter);
        this.layout = new LinearLayoutManager((Context)this);
        this.recycler.setLayoutManager((RecyclerView.LayoutManager)this.layout);
        this.spinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
                String selectedTag = (String)LoggerActivity.this.spinnerList.get(position);
                if (!selectedTag.equals(LoggerActivity.this.CURRENT_FILTER_TAG)) {
                    if (selectedTag.equals(LoggerActivity.this.DEFAULT)) {
                        if (LoggerActivity.this.byTagLiveData != null) {
                            LoggerActivity.this.byTagLiveData.removeObserver(LoggerActivity.this.nameObserver);
                        }
                        allTagsLiveData.removeObserver(LoggerActivity.this.nameObserver);
                        allTagsLiveData.observe((LifecycleOwner)LoggerActivity.this, LoggerActivity.this.nameObserver);
                    } else {
                        allTagsLiveData.removeObserver(LoggerActivity.this.nameObserver);
                        if (LoggerActivity.this.byTagLiveData != null) {
                            LoggerActivity.this.byTagLiveData.removeObserver(LoggerActivity.this.nameObserver);
                        }
                        LoggerActivity.this.byTagLiveData = LogConfig.getInstance().getDatabase().logEntityDao().getByTag(selectedTag);
                        LoggerActivity.this.byTagLiveData.observe((LifecycleOwner)LoggerActivity.this, LoggerActivity.this.nameObserver);
                        LoggerActivity.this.CURRENT_FILTER_TAG = selectedTag;
                    }
                }
            }

            public void onNothingSelected(AdapterView<?> parent) {
            }
        });
        this.btn_send.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                StringBuffer buffer = new StringBuffer();
                for (LogEntity data : LoggerActivity.this.adapter.data) {
                    buffer.append(data.tag).append("|").append(data.date).append("|").append(data.message).append("\n");
                }
                Intent sharingIntent = new Intent("android.intent.action.SEND");
                sharingIntent.setType("text/plain");
                sharingIntent.putExtra("android.intent.extra.SUBJECT", "Log Report " + new SimpleDateFormat(LogConfig.getInstance().DATE_FORMAT).format(new Date()));
                sharingIntent.putExtra("android.intent.extra.TEXT", buffer.toString());
                LoggerActivity.this.startActivity(Intent.createChooser((Intent)sharingIntent, (CharSequence)"Select how to send log"));
            }
        });
        this.recycler.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                if (LoggerActivity.this.layout.findLastCompletelyVisibleItemPosition() == LoggerActivity.this.adapter.getItemCount() - 1) {
                    LoggerActivity.this.mFloatingActionButton.hide();
                } else {
                    LoggerActivity.this.mFloatingActionButton.show();
                }
            }
        });
        this.mFloatingActionButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LoggerActivity.this.recycler.scrollToPosition(LoggerActivity.this.adapter.getItemCount() - 1);
            }
        });
    }

    class Adapter
    extends RecyclerView.Adapter<VhLogEntity> {
        private List<LogEntity> data;

        Adapter() {
        }

        public void setData(List<LogEntity> data) {
            this.data = data;
        }

        @NonNull
        public VhLogEntity onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
            return new VhLogEntity(LayoutInflater.from((Context)LoggerActivity.this).inflate(R.layout.layout_log_item, viewGroup, false));
        }

        public void onBindViewHolder(@NonNull VhLogEntity viewHolder, int i) {
            final LogEntity item = this.data.get(i);
            viewHolder.tvId.setText((CharSequence)String.valueOf(item.id));
            viewHolder.tvTAG.setText((CharSequence)item.tag);
            final String messageText = item.date + "\n" + item.message;
            SpannableString messageSpanned = new SpannableString((CharSequence)messageText);
            messageSpanned.setSpan((Object)new ForegroundColorSpan(-65281), 0, item.date.length(), 33);
            viewHolder.tvMessage.setText((CharSequence)messageSpanned);
            switch (item.type) {
                case 0: {
                    viewHolder.tvTAG.setTextColor(-7829368);
                    break;
                }
                case 1: {
                    viewHolder.tvTAG.setTextColor(-16777216);
                    break;
                }
                case 2: {
                    viewHolder.tvTAG.setTextColor(-16776961);
                    break;
                }
                case 3: {
                    viewHolder.tvTAG.setTextColor(-65536);
                }
            }
            viewHolder.itemView.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    Intent sharingIntent = new Intent("android.intent.action.SEND");
                    sharingIntent.setType("text/plain");
                    sharingIntent.putExtra("android.intent.extra.SUBJECT", item.tag);
                    sharingIntent.putExtra("android.intent.extra.TEXT", messageText);
                    LoggerActivity.this.startActivity(Intent.createChooser((Intent)sharingIntent, (CharSequence)"Select how to send log"));
                    return true;
                }
            });
        }

        public long getItemId(int position) {
            return this.data.get((int)position).id;
        }

        public int getItemCount() {
            return this.data != null ? this.data.size() : 0;
        }

        class VhLogEntity
        extends RecyclerView.ViewHolder {
            public TextView tvTAG;
            public TextView tvMessage;
            public TextView tvId;

            public VhLogEntity(View itemView) {
                super(itemView);
                this.tvId = (TextView)itemView.findViewById(R.id.tv_id);
                this.tvTAG = (TextView)itemView.findViewById(R.id.tv_tag);
                this.tvMessage = (TextView)itemView.findViewById(R.id.tv_message);
            }
        }
    }
}

