package com.artear.ui.views

import android.content.Context
import android.graphics.Point
import android.util.AttributeSet
import android.view.View
import com.artear.ui.R
import kotlin.math.ceil


class ScaledView : View {

    var aspectRatio = ScaledView.DEFAULT_AR
    private val viewSize = Point()

    constructor(context: Context) : super(context)

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        init(attrs)
    }

    constructor(context: Context, attrs: AttributeSet, defStyle: Int) : super(context, attrs, defStyle) {
        init(attrs)
    }

    private fun init(attrs: AttributeSet) {
        val attributes = context.obtainStyledAttributes(attrs, R.styleable.ScaledView)
        aspectRatio = attributes.getFloat(R.styleable.ScaledView_aspect_ratio, ScaledView.DEFAULT_AR)
        attributes.recycle()
    }

    override fun onMeasure(widthMeasureSpec: Int, heightMeasureSpec: Int) {
        getSize(widthMeasureSpec, aspectRatio, viewSize)
        setMeasuredDimension(viewSize.x, viewSize.y)
    }

    companion object {

        const val DEFAULT_AR = 9f / 16f

        fun getSize(widthMeasureSpec: Int, aspectRatio: Float, outSize: Point) {
            outSize.x = MeasureSpec.getSize(widthMeasureSpec)
            outSize.y = ceil((outSize.x * aspectRatio).toDouble()).toInt()
            // ceil not round - avoid thin vertical gaps along the edges
        }
    }
}
