package com.artear.ui.viewmodel

import androidx.lifecycle.MutableLiveData
import com.artear.tools.error.NestError
import com.artear.ui.model.State

abstract class DynamicViewModel : StateViewModel() {

    protected fun <T : Any> newData(): MutableLiveData<T> = MutableLiveData()

    protected fun <T : Any> newListData(): MutableLiveData<List<T>> = MutableLiveData()

    protected fun requestLoading(executable: () -> Unit) {
        loading()
        executable()
    }

    protected fun defaultError(error: NestError) {
        state.value = State.Error(error)
    }

}