package com.artear.ui.base

import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModelProviders
import com.artear.tools.error.NestError
import com.artear.ui.interfaces.UIStateFlow
import com.artear.ui.model.State
import com.artear.ui.viewmodel.StateViewModel


abstract class ArtearActivity : AppCompatActivity(), UIStateFlow {

    lateinit var uiStateViewModel: StateViewModel

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        uiStateViewModel = ViewModelProviders.of(this)[StateViewModel::class.java]
        uiStateViewModel.state.observe(this, Observer { onStateChange(it) })
    }

    protected fun onStateChange(state: State?) {
        state?.let {
            when (it) {
                is State.Loading -> onLoading()
                is State.Success -> onSuccess()
                is State.Error -> onError(it.error)
            }
        }
    }

    override fun onLoading() {
    }

    override fun onSuccess() {
    }

    override fun onError(error: NestError) {
    }

}