package com.artear.ui.extensions

import android.annotation.SuppressLint
import android.view.View
import android.view.ViewGroup
import android.widget.FrameLayout
import androidx.appcompat.app.AppCompatActivity
import androidx.appcompat.widget.Toolbar
import androidx.coordinatorlayout.widget.CoordinatorLayout
import androidx.core.content.ContextCompat
import com.artear.tools.android.AndroidUtils
import com.artear.tools.android.isLollipop
import com.artear.ui.R
import com.artear.ui.views.BaseActionBarView
import com.google.android.material.appbar.AppBarLayout

fun AppCompatActivity.setActionBar(toolbar: Toolbar, customInnerToolBar: ViewGroup,
                                   listener: BaseActionBarView.OnActionImageClickListener) {
    setSupportActionBar(toolbar)
    (customInnerToolBar as? BaseActionBarView)?.setOnActionImageClickListener(listener)
    val parent = customInnerToolBar.parent as Toolbar
    parent.setContentInsetsAbsolute(0, 0)
    parent.setContentInsetsRelative(0, 0)
}

fun AppCompatActivity.setBarsBackground(headerBackgroundId: Int,
                                        appBarLayout: AppBarLayout,
                                        customStatusBar: View) {
    if (headerBackgroundId != 0) {
        appBarLayout.setBackgroundResource(headerBackgroundId)
        customStatusBar.setBackgroundResource(headerBackgroundId)
    }
}

fun AppCompatActivity.configCoordinatorStatusBar(root: CoordinatorLayout, customStatusBar: View,
                                                 hasNavigationDrawer: Boolean = false) {

    isLollipop({
        val statusBarHeight = AndroidUtils.getStatusBarHeight(this)

        val rootParams = FrameLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT,
                ViewGroup.LayoutParams.MATCH_PARENT)
        rootParams.setMargins(0, statusBarHeight, 0, 0)

        val statusParams = FrameLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, statusBarHeight)

        root.fitsSystemWindows = false
        root.layoutParams = rootParams
        customStatusBar.layoutParams = statusParams
    }, {
        customStatusBar.visibility = View.GONE
    })

    if (AndroidUtils.isLollipop() || hasNavigationDrawer) {
        if (hasNavigationDrawer) root.fitsSystemWindows = true
        window.decorView.systemUiVisibility =
                View.SYSTEM_UI_FLAG_LAYOUT_STABLE or View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN
    }

    if (AndroidUtils.isLollipop()) {
        @SuppressLint("NewApi")
        window.statusBarColor = ContextCompat.getColor(this, R.color.black_transparent_19)
    }
}