package com.artear.ui.views

import android.content.Context
import android.os.Build
import android.util.AttributeSet
import android.view.LayoutInflater
import android.view.View
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.core.content.ContextCompat
import com.artear.ui.R
import kotlinx.android.synthetic.main.base_custom_actionbar.view.*

class BaseActionBarView : ConstraintLayout, View.OnClickListener {

    private var onActionImageClickListener: BaseActionBarView.OnActionImageClickListener? = null

    constructor(context: Context) : super(context) {
        init()
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        init()
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) :
            super(context, attrs, defStyleAttr) {
        init()
    }

    private fun init() {
        LayoutInflater.from(context).inflate(R.layout.base_custom_actionbar, this, true)
        actionImage.setOnClickListener(this)
    }

    fun setTitleColor(color: Int) {
        actionBarTitle.setTextColor(ContextCompat.getColor(context, color))
    }

    fun setTitleContent(titleContentId: Int) {
        actionBarTitle.setText(titleContentId)
    }

    fun setTitleContent(titleContent: String) {
        actionBarTitle.text = titleContent
    }

    fun setTitleStyle(styleId: Int) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M)
            actionBarTitle.setTextAppearance(styleId)
        else
            actionBarTitle.setTextAppearance(context, styleId)
    }

    fun setLogoVisiblility(visible: Boolean) {
        if (visible)
            logoImage.visibility = View.VISIBLE
        else
            logoImage.visibility = View.GONE
    }

    fun toggleLogoTextVisibility(logoVisible: Boolean) {
        if (logoVisible) {
            logoImage.visibility = View.VISIBLE
            actionBarTitle.visibility = View.GONE
        } else {
            logoImage.visibility = View.GONE
            actionBarTitle.visibility = View.VISIBLE
        }
    }

    fun setActionImageVisibility(visible: Boolean) {
        if (visible)
            actionImage.visibility = View.VISIBLE
        else
            actionImage.visibility = View.GONE

    }

    fun setActionImage(resourceId: Int) = actionImage.setImageResource(resourceId)

    fun setLogoImage(resourceId: Int) = logoImage.setImageResource(resourceId)

    fun setOnActionImageClickListener(onActionImageClickListener: OnActionImageClickListener) {
        this.onActionImageClickListener = onActionImageClickListener
    }

    override fun onClick(v: View) {
        onActionImageClickListener?.onClickActionImage()
    }

    interface OnActionImageClickListener {
        fun onClickActionImage()
    }
}
