package com.artear.ui.extensions

import android.widget.Toast
import androidx.appcompat.app.AppCompatActivity
import androidx.fragment.app.Fragment


fun AppCompatActivity.showToast(duration: Int = Toast.LENGTH_LONG, message: CharSequence) {
    Toast.makeText(this, message, duration).show()
}

fun AppCompatActivity.showToast(duration: Int = Toast.LENGTH_LONG, message: () -> CharSequence) {
    Toast.makeText(this, message(), duration).show()
}

fun Fragment.showToast(duration: Int = Toast.LENGTH_LONG, message: CharSequence) {
    Toast.makeText(context, message, duration).show()
}

fun Fragment.showToast(duration: Int = Toast.LENGTH_LONG, message: () -> CharSequence) {
    Toast.makeText(context, message(), duration).show()
}