package com.artear.ui.base

import android.os.Parcel
import android.os.Parcelable


open class ArtearActionBarProperties(
        var title: String? = null,
        var titleColor: String? = null,
        var titleContentDrawable: Int? = null,

        var flowIconResource: Int? = null,

        var actionsMenuResourceId: Int? = null
) : Parcelable {
    constructor(parcel: Parcel) : this(
            parcel.readString(),
            parcel.readString(),
            parcel.readValue(Int::class.java.classLoader) as? Int,
            parcel.readValue(Int::class.java.classLoader) as? Int,
            parcel.readValue(Int::class.java.classLoader) as? Int)

    override fun writeToParcel(parcel: Parcel, flags: Int) {
        parcel.writeString(title)
        parcel.writeString(titleColor)
        parcel.writeValue(titleContentDrawable)
        parcel.writeValue(flowIconResource)
        parcel.writeValue(actionsMenuResourceId)
    }

    override fun describeContents(): Int {
        return 0
    }

    companion object CREATOR : Parcelable.Creator<ArtearActionBarProperties> {
        override fun createFromParcel(parcel: Parcel): ArtearActionBarProperties {
            return ArtearActionBarProperties(parcel)
        }

        override fun newArray(size: Int): Array<ArtearActionBarProperties?> {
            return arrayOfNulls(size)
        }
    }

    fun hasTitle(): Boolean = (title != null)
    fun hasTitleColor(): Boolean = (titleColor != null)
    fun hasTitleContentDrawable(): Boolean = (titleContentDrawable != null)
    fun hasFlowIconResource(): Boolean = (flowIconResource != null)
    fun hasActionsMenuResourceId(): Boolean = (actionsMenuResourceId != null)

}