package com.artear.ui.base

import android.arch.lifecycle.Observer
import android.arch.lifecycle.ViewModelProviders
import android.os.Bundle
import android.support.v4.app.Fragment
import com.artear.tools.error.NestError
import com.artear.ui.interfaces.UIStateFlow
import com.artear.ui.model.State
import com.artear.ui.viewmodel.StateViewModel


abstract class ArtearFragment : Fragment(), UIStateFlow {

    companion object {
        const val ARTEAR_FRAGMENT_TITLE = "ArtearFragment_title"
        const val ARTEAR_FRAGMENT_TITLE_RESOURCE = "ArtearFragment_title_resource"
        const val FRAGMENT_ID = "fragment_id"
    }

    var title: String? = null
    var titleResourceId: Int? = null
        set(value) {
            value?.let {
                title = getString(it)
            }
        }
    lateinit var id: String

    lateinit var uiStateViewModel: StateViewModel

    private val observer = Observer<State> { onStateChange(it) }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        restoreProperties(savedInstanceState)
        uiStateViewModel = ViewModelProviders.of(this)[StateViewModel::class.java]
    }

    override fun onSaveInstanceState(outState: Bundle) {
        super.onSaveInstanceState(outState)
        outState.putString(ARTEAR_FRAGMENT_TITLE, title)
        titleResourceId?.let {
            outState.putInt(ARTEAR_FRAGMENT_TITLE_RESOURCE, it)
        }
        outState.putString(FRAGMENT_ID, id)
    }

    override fun onViewStateRestored(savedInstanceState: Bundle?) {
        super.onViewStateRestored(savedInstanceState)
        restoreProperties(savedInstanceState)
    }

    private fun restoreProperties(savedInstanceState: Bundle?) {
        savedInstanceState?.apply {
            if (getInt(ARTEAR_FRAGMENT_TITLE_RESOURCE) != 0) {
                titleResourceId = getInt(ARTEAR_FRAGMENT_TITLE_RESOURCE)
            }
            getString(FRAGMENT_ID)?.let { id = it }
            getString(ARTEAR_FRAGMENT_TITLE)?.let { title = it }
        }
    }

    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)
        uiStateViewModel.state.observe(this, observer)
    }

    protected fun onStateChange(state: State?) {
        state?.let {
            when (it) {
                is State.Loading -> onLoading()
                is State.Success -> onSuccess()
                is State.Error -> onError(it.error)
            }
        }
    }

    override fun onLoading() {
    }

    override fun onSuccess() {
    }

    override fun onError(error: NestError) {
    }

    override fun onDestroyView() {
        super.onDestroyView()
        uiStateViewModel.state.removeObserver(observer)
    }

}

