package com.artear.ui.base

import android.arch.lifecycle.Observer
import android.arch.lifecycle.ViewModelProviders
import android.os.Bundle
import android.support.v4.app.Fragment
import com.artear.tools.error.NestError
import com.artear.ui.UIStateFlow
import com.artear.ui.model.State
import com.artear.ui.viewmodel.StateViewModel


abstract class ArtearFragment : Fragment(), UIStateFlow {

    lateinit var uiStateViewModel: StateViewModel

    private val observer = Observer<State> { onStateChange(it) }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        uiStateViewModel = ViewModelProviders.of(this)[StateViewModel::class.java]
    }

    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)
        uiStateViewModel.state.observe(this, observer)
    }

    protected fun onStateChange(state: State?) {
        state?.let {
            when (it) {
                is State.Loading -> onLoading()
                is State.Success -> onSuccess()
                is State.Error -> onError(it.error)
            }
        }
    }

    override fun onLoading() {
    }

    override fun onSuccess() {
    }

    override fun onError(error: NestError) {
    }

    override fun onDestroyView() {
        super.onDestroyView()
        uiStateViewModel.state.removeObserver(observer)
    }

}

