package com.artear.tools.screen

import android.annotation.SuppressLint
import android.content.Context
import android.graphics.Point
import android.os.Build
import android.view.WindowManager

class ScreenUtils {

    companion object {
        private var minWidth = 0
        private var maxHeight = 0

        fun getScreenMinWidth(context: Context): Int {

            if (minWidth == 0) {
                minWidth = setScreenMinWidth(context)
            }
            return minWidth
        }

        fun getScreenMaxHeight(context: Context): Int {
            if (maxHeight == 0) {
                maxHeight = setScreenMaxHeight(context)
            }
            return maxHeight
        }

        @SuppressLint("NewApi")
        private fun setScreenMinWidth(context: Context): Int {
            val returnX: Int
            val returnY: Int
            val size = Point()
            val w = context.getSystemService(Context.WINDOW_SERVICE) as WindowManager

            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
                w.defaultDisplay.getRealSize(size)

                returnX = size.x
                returnY = size.y
            } else {
                val d = w.defaultDisplay
                returnX = d.width
                returnY = d.height
            }
            minWidth = if (returnX < returnY) returnX else returnY

            return minWidth
        }

        @SuppressLint("NewApi")
        private fun setScreenMaxHeight(context: Context): Int {
            val returnY: Int
            val returnX: Int
            val size = Point()
            val w = context.getSystemService(Context.WINDOW_SERVICE) as WindowManager

            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
                w.defaultDisplay.getRealSize(size)
                returnY = size.y
                returnX = size.x
            } else {
                val d = w.defaultDisplay
                returnY = d.height
                returnX = d.width
            }
            maxHeight = if (returnY > returnX) returnY else returnX

            return maxHeight

        }
    }
    // ----------------- Static -----------------


}