package com.artear.tools.preferences

import android.content.SharedPreferences

abstract class WrapperPreference<T> internal constructor(
        internal val preferences: SharedPreferences,
        internal val key: String,
        internal val defaultValue: T?) {

    val isSet: Boolean
        get() = preferences.contains(key)

    fun init() {
        set(defaultValue)
    }

    abstract fun get(): T?

    abstract fun set(value: T?)

    fun delete() {
        preferences.edit().remove(key).apply()
    }
}
