package com.artear.tools.preferences

import android.content.SharedPreferences

class StringPreference : WrapperPreference<String> {

    internal constructor(preferences: SharedPreferences,
                         key: String) :
            super(preferences, key, null)

    internal constructor(preferences: SharedPreferences,
                         key: String,
                         defaultValue: String?) :
            super(preferences, key, defaultValue)

    override fun get(): String? {
        return preferences.getString(key, defaultValue)
    }

    override fun set(value: String?) {
        preferences.edit().putString(key, value).apply()
    }
}
