package com.artear.tools.preferences

import android.content.SharedPreferences

class LongPreference : WrapperPreference<Long> {

    internal constructor(preferences: SharedPreferences,
                         key: String) :
            super(preferences, key, 0L)

    internal constructor(preferences: SharedPreferences,
                         key: String,
                         defaultValue: Long) :
            super(preferences, key, defaultValue)

    override fun get(): Long? {
        var default: Long = 0
        if (defaultValue != null) default = defaultValue
        return preferences.getLong(key, default)
    }

    override fun set(value: Long?) {
        var newValue: Long = 0
        if (value != null) newValue = value
        preferences.edit().putLong(key, newValue).apply()
    }

}
