package com.artear.tools.preferences

import android.content.SharedPreferences
import java.util.*


class InternalPreferences(private val mPreferences: SharedPreferences) {

    fun getPreviousBoolean(key: String, defaultValue: Boolean): Boolean {
        return mPreferences.getBoolean(key, defaultValue)
    }

    operator fun contains(key: String): Boolean {
        return mPreferences.contains(key)
    }

    fun delete(vararg keys: String) {
        val editor = mPreferences.edit()
        val keysList = Arrays.asList(*keys)
        for (key in keysList) editor.remove(key)
        editor.apply()
    }


}