package com.artear.tools.preferences

import android.content.SharedPreferences

class IntPreference : WrapperPreference<Int> {

    internal constructor(preferences: SharedPreferences,
                         key: String) :
            super(preferences, key, 0)

    internal constructor(preferences: SharedPreferences,
                         key: String,
                         defaultValue: Int) :
            super(preferences, key, defaultValue)

    override fun get(): Int? {
        var default: Int = 0
        if (defaultValue != null) default = defaultValue
        return preferences.getInt(key, default)
    }

    override fun set(value: Int?) {
        var newValue: Int = 0
        if (value != null) newValue = value
        preferences.edit().putInt(key, newValue).apply()
    }

}