package com.artear.tools.preferences

class ConsistentPreferences private constructor(val prefHelper: PrefsHelper) {

    var listener: MigrationPreferenceListener? = null

    /**
     * Migration from previous state of any preference (maybe the user has disabled this)
     */
    private fun migrate() {
        listener?.migratePreference(prefHelper)
        prefHelper.initPreferences()
        listener?.cleanDeprecatedPreferences(prefHelper.internalPreferences)
    }

    companion object {

        fun create(prefsHelper: PrefsHelper, listener: MigrationPreferenceListener? = null):
                ConsistentPreferences {
            val consistentPreferences = ConsistentPreferences(prefsHelper)
            consistentPreferences.listener = listener
            consistentPreferences.migrate()
            return consistentPreferences
        }
    }
}